/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.DeliveryChannel;
import software.amazon.awssdk.services.config.model.DeliveryChannelListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDeliveryChannelsResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeDeliveryChannelsResponse> {
    private static final SdkField<List<DeliveryChannel>> DELIVERY_CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeliveryChannels").getter(DescribeDeliveryChannelsResponse.getter(DescribeDeliveryChannelsResponse::deliveryChannels)).setter(DescribeDeliveryChannelsResponse.setter(Builder::deliveryChannels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryChannels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeliveryChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_CHANNELS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DeliveryChannels", DELIVERY_CHANNELS_FIELD);
        }
    });
    private final List<DeliveryChannel> deliveryChannels;

    private DescribeDeliveryChannelsResponse(BuilderImpl builder) {
        super(builder);
        this.deliveryChannels = builder.deliveryChannels;
    }

    public final boolean hasDeliveryChannels() {
        return this.deliveryChannels != null && !(this.deliveryChannels instanceof SdkAutoConstructList);
    }

    public final List<DeliveryChannel> deliveryChannels() {
        return this.deliveryChannels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeliveryChannels() ? this.deliveryChannels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeliveryChannelsResponse)) {
            return false;
        }
        DescribeDeliveryChannelsResponse other = (DescribeDeliveryChannelsResponse)((Object)obj);
        return this.hasDeliveryChannels() == other.hasDeliveryChannels() && Objects.equals(this.deliveryChannels(), other.deliveryChannels());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDeliveryChannelsResponse").add("DeliveryChannels", this.hasDeliveryChannels() ? this.deliveryChannels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryChannels": {
                return Optional.ofNullable(clazz.cast(this.deliveryChannels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeliveryChannelsResponse, T> g) {
        return obj -> g.apply((DescribeDeliveryChannelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<DeliveryChannel> deliveryChannels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeliveryChannelsResponse model) {
            super(model);
            this.deliveryChannels(model.deliveryChannels);
        }

        public final List<DeliveryChannel.Builder> getDeliveryChannels() {
            List<DeliveryChannel.Builder> result = DeliveryChannelListCopier.copyToBuilder(this.deliveryChannels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeliveryChannels(Collection<DeliveryChannel.BuilderImpl> deliveryChannels) {
            this.deliveryChannels = DeliveryChannelListCopier.copyFromBuilder(deliveryChannels);
        }

        @Override
        public final Builder deliveryChannels(Collection<DeliveryChannel> deliveryChannels) {
            this.deliveryChannels = DeliveryChannelListCopier.copy(deliveryChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryChannels(DeliveryChannel ... deliveryChannels) {
            this.deliveryChannels(Arrays.asList(deliveryChannels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryChannels(Consumer<DeliveryChannel.Builder> ... deliveryChannels) {
            this.deliveryChannels(Stream.of(deliveryChannels).map(c -> (DeliveryChannel)((DeliveryChannel.Builder)DeliveryChannel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeDeliveryChannelsResponse build() {
            return new DescribeDeliveryChannelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDeliveryChannelsResponse> {
        public Builder deliveryChannels(Collection<DeliveryChannel> var1);

        public Builder deliveryChannels(DeliveryChannel ... var1);

        public Builder deliveryChannels(Consumer<DeliveryChannel.Builder> ... var1);
    }
}

