/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PageBasedErrorCode {
    TEXTRACT_BAD_PAGE("TEXTRACT_BAD_PAGE"),
    TEXTRACT_PROVISIONED_THROUGHPUT_EXCEEDED("TEXTRACT_PROVISIONED_THROUGHPUT_EXCEEDED"),
    PAGE_CHARACTERS_EXCEEDED("PAGE_CHARACTERS_EXCEEDED"),
    PAGE_SIZE_EXCEEDED("PAGE_SIZE_EXCEEDED"),
    INTERNAL_SERVER_ERROR("INTERNAL_SERVER_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PageBasedErrorCode> VALUE_MAP;
    private final String value;

    private PageBasedErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PageBasedErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PageBasedErrorCode> knownValues() {
        EnumSet<PageBasedErrorCode> knownValues = EnumSet.allOf(PageBasedErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PageBasedErrorCode.class, PageBasedErrorCode::toString);
    }
}

