/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AnalyticsMetadataType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AuthParametersTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ClientMetadataTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserContextDataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InitiateAuthRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, InitiateAuthRequest> {
    private static final SdkField<String> AUTH_FLOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthFlow").getter(InitiateAuthRequest.getter(InitiateAuthRequest::authFlowAsString)).setter(InitiateAuthRequest.setter(Builder::authFlow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthFlow").build()}).build();
    private static final SdkField<Map<String, String>> AUTH_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AuthParameters").getter(InitiateAuthRequest.getter(InitiateAuthRequest::authParameters)).setter(InitiateAuthRequest.setter(Builder::authParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CLIENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ClientMetadata").getter(InitiateAuthRequest.getter(InitiateAuthRequest::clientMetadata)).setter(InitiateAuthRequest.setter(Builder::clientMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(InitiateAuthRequest.getter(InitiateAuthRequest::clientId)).setter(InitiateAuthRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<AnalyticsMetadataType> ANALYTICS_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnalyticsMetadata").getter(InitiateAuthRequest.getter(InitiateAuthRequest::analyticsMetadata)).setter(InitiateAuthRequest.setter(Builder::analyticsMetadata)).constructor(AnalyticsMetadataType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyticsMetadata").build()}).build();
    private static final SdkField<UserContextDataType> USER_CONTEXT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserContextData").getter(InitiateAuthRequest.getter(InitiateAuthRequest::userContextData)).setter(InitiateAuthRequest.setter(Builder::userContextData)).constructor(UserContextDataType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserContextData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_FLOW_FIELD, AUTH_PARAMETERS_FIELD, CLIENT_METADATA_FIELD, CLIENT_ID_FIELD, ANALYTICS_METADATA_FIELD, USER_CONTEXT_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AuthFlow", AUTH_FLOW_FIELD);
            this.put("AuthParameters", AUTH_PARAMETERS_FIELD);
            this.put("ClientMetadata", CLIENT_METADATA_FIELD);
            this.put("ClientId", CLIENT_ID_FIELD);
            this.put("AnalyticsMetadata", ANALYTICS_METADATA_FIELD);
            this.put("UserContextData", USER_CONTEXT_DATA_FIELD);
        }
    });
    private final String authFlow;
    private final Map<String, String> authParameters;
    private final Map<String, String> clientMetadata;
    private final String clientId;
    private final AnalyticsMetadataType analyticsMetadata;
    private final UserContextDataType userContextData;

    private InitiateAuthRequest(BuilderImpl builder) {
        super(builder);
        this.authFlow = builder.authFlow;
        this.authParameters = builder.authParameters;
        this.clientMetadata = builder.clientMetadata;
        this.clientId = builder.clientId;
        this.analyticsMetadata = builder.analyticsMetadata;
        this.userContextData = builder.userContextData;
    }

    public final AuthFlowType authFlow() {
        return AuthFlowType.fromValue(this.authFlow);
    }

    public final String authFlowAsString() {
        return this.authFlow;
    }

    public final boolean hasAuthParameters() {
        return this.authParameters != null && !(this.authParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> authParameters() {
        return this.authParameters;
    }

    public final boolean hasClientMetadata() {
        return this.clientMetadata != null && !(this.clientMetadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> clientMetadata() {
        return this.clientMetadata;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final AnalyticsMetadataType analyticsMetadata() {
        return this.analyticsMetadata;
    }

    public final UserContextDataType userContextData() {
        return this.userContextData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authFlowAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthParameters() ? this.authParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientMetadata() ? this.clientMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyticsMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.userContextData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateAuthRequest)) {
            return false;
        }
        InitiateAuthRequest other = (InitiateAuthRequest)((Object)obj);
        return Objects.equals(this.authFlowAsString(), other.authFlowAsString()) && this.hasAuthParameters() == other.hasAuthParameters() && Objects.equals(this.authParameters(), other.authParameters()) && this.hasClientMetadata() == other.hasClientMetadata() && Objects.equals(this.clientMetadata(), other.clientMetadata()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.analyticsMetadata(), other.analyticsMetadata()) && Objects.equals(this.userContextData(), other.userContextData());
    }

    public final String toString() {
        return ToString.builder((String)"InitiateAuthRequest").add("AuthFlow", (Object)this.authFlowAsString()).add("AuthParameters", (Object)(this.authParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientMetadata", this.hasClientMetadata() ? this.clientMetadata() : null).add("ClientId", (Object)(this.clientId() == null ? null : "*** Sensitive Data Redacted ***")).add("AnalyticsMetadata", (Object)this.analyticsMetadata()).add("UserContextData", (Object)(this.userContextData() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthFlow": {
                return Optional.ofNullable(clazz.cast(this.authFlowAsString()));
            }
            case "AuthParameters": {
                return Optional.ofNullable(clazz.cast(this.authParameters()));
            }
            case "ClientMetadata": {
                return Optional.ofNullable(clazz.cast(this.clientMetadata()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "AnalyticsMetadata": {
                return Optional.ofNullable(clazz.cast(this.analyticsMetadata()));
            }
            case "UserContextData": {
                return Optional.ofNullable(clazz.cast(this.userContextData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InitiateAuthRequest, T> g) {
        return obj -> g.apply((InitiateAuthRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String authFlow;
        private Map<String, String> authParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> clientMetadata = DefaultSdkAutoConstructMap.getInstance();
        private String clientId;
        private AnalyticsMetadataType analyticsMetadata;
        private UserContextDataType userContextData;

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateAuthRequest model) {
            super(model);
            this.authFlow(model.authFlow);
            this.authParameters(model.authParameters);
            this.clientMetadata(model.clientMetadata);
            this.clientId(model.clientId);
            this.analyticsMetadata(model.analyticsMetadata);
            this.userContextData(model.userContextData);
        }

        public final String getAuthFlow() {
            return this.authFlow;
        }

        public final void setAuthFlow(String authFlow) {
            this.authFlow = authFlow;
        }

        @Override
        public final Builder authFlow(String authFlow) {
            this.authFlow = authFlow;
            return this;
        }

        @Override
        public final Builder authFlow(AuthFlowType authFlow) {
            this.authFlow(authFlow == null ? null : authFlow.toString());
            return this;
        }

        public final Map<String, String> getAuthParameters() {
            if (this.authParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.authParameters;
        }

        public final void setAuthParameters(Map<String, String> authParameters) {
            this.authParameters = AuthParametersTypeCopier.copy(authParameters);
        }

        @Override
        public final Builder authParameters(Map<String, String> authParameters) {
            this.authParameters = AuthParametersTypeCopier.copy(authParameters);
            return this;
        }

        public final Map<String, String> getClientMetadata() {
            if (this.clientMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.clientMetadata;
        }

        public final void setClientMetadata(Map<String, String> clientMetadata) {
            this.clientMetadata = ClientMetadataTypeCopier.copy(clientMetadata);
        }

        @Override
        public final Builder clientMetadata(Map<String, String> clientMetadata) {
            this.clientMetadata = ClientMetadataTypeCopier.copy(clientMetadata);
            return this;
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final AnalyticsMetadataType.Builder getAnalyticsMetadata() {
            return this.analyticsMetadata != null ? this.analyticsMetadata.toBuilder() : null;
        }

        public final void setAnalyticsMetadata(AnalyticsMetadataType.BuilderImpl analyticsMetadata) {
            this.analyticsMetadata = analyticsMetadata != null ? analyticsMetadata.build() : null;
        }

        @Override
        public final Builder analyticsMetadata(AnalyticsMetadataType analyticsMetadata) {
            this.analyticsMetadata = analyticsMetadata;
            return this;
        }

        public final UserContextDataType.Builder getUserContextData() {
            return this.userContextData != null ? this.userContextData.toBuilder() : null;
        }

        public final void setUserContextData(UserContextDataType.BuilderImpl userContextData) {
            this.userContextData = userContextData != null ? userContextData.build() : null;
        }

        @Override
        public final Builder userContextData(UserContextDataType userContextData) {
            this.userContextData = userContextData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InitiateAuthRequest build() {
            return new InitiateAuthRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InitiateAuthRequest> {
        public Builder authFlow(String var1);

        public Builder authFlow(AuthFlowType var1);

        public Builder authParameters(Map<String, String> var1);

        public Builder clientMetadata(Map<String, String> var1);

        public Builder clientId(String var1);

        public Builder analyticsMetadata(AnalyticsMetadataType var1);

        default public Builder analyticsMetadata(Consumer<AnalyticsMetadataType.Builder> analyticsMetadata) {
            return this.analyticsMetadata((AnalyticsMetadataType)((AnalyticsMetadataType.Builder)AnalyticsMetadataType.builder().applyMutation(analyticsMetadata)).build());
        }

        public Builder userContextData(UserContextDataType var1);

        default public Builder userContextData(Consumer<UserContextDataType.Builder> userContextData) {
            return this.userContextData((UserContextDataType)((UserContextDataType.Builder)UserContextDataType.builder().applyMutation(userContextData)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

