/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeNameListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteUserAttributesRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, DeleteUserAttributesRequest> {
    private static final SdkField<List<String>> USER_ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserAttributeNames").getter(DeleteUserAttributesRequest.getter(DeleteUserAttributesRequest::userAttributeNames)).setter(DeleteUserAttributesRequest.setter(Builder::userAttributeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAttributeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessToken").getter(DeleteUserAttributesRequest.getter(DeleteUserAttributesRequest::accessToken)).setter(DeleteUserAttributesRequest.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ATTRIBUTE_NAMES_FIELD, ACCESS_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UserAttributeNames", USER_ATTRIBUTE_NAMES_FIELD);
            this.put("AccessToken", ACCESS_TOKEN_FIELD);
        }
    });
    private final List<String> userAttributeNames;
    private final String accessToken;

    private DeleteUserAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.userAttributeNames = builder.userAttributeNames;
        this.accessToken = builder.accessToken;
    }

    public final boolean hasUserAttributeNames() {
        return this.userAttributeNames != null && !(this.userAttributeNames instanceof SdkAutoConstructList);
    }

    public final List<String> userAttributeNames() {
        return this.userAttributeNames;
    }

    public final String accessToken() {
        return this.accessToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserAttributeNames() ? this.userAttributeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteUserAttributesRequest)) {
            return false;
        }
        DeleteUserAttributesRequest other = (DeleteUserAttributesRequest)((Object)obj);
        return this.hasUserAttributeNames() == other.hasUserAttributeNames() && Objects.equals(this.userAttributeNames(), other.userAttributeNames()) && Objects.equals(this.accessToken(), other.accessToken());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteUserAttributesRequest").add("UserAttributeNames", this.hasUserAttributeNames() ? this.userAttributeNames() : null).add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserAttributeNames": {
                return Optional.ofNullable(clazz.cast(this.userAttributeNames()));
            }
            case "AccessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteUserAttributesRequest, T> g) {
        return obj -> g.apply((DeleteUserAttributesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private List<String> userAttributeNames = DefaultSdkAutoConstructList.getInstance();
        private String accessToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteUserAttributesRequest model) {
            super(model);
            this.userAttributeNames(model.userAttributeNames);
            this.accessToken(model.accessToken);
        }

        public final Collection<String> getUserAttributeNames() {
            if (this.userAttributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userAttributeNames;
        }

        public final void setUserAttributeNames(Collection<String> userAttributeNames) {
            this.userAttributeNames = AttributeNameListTypeCopier.copy(userAttributeNames);
        }

        @Override
        public final Builder userAttributeNames(Collection<String> userAttributeNames) {
            this.userAttributeNames = AttributeNameListTypeCopier.copy(userAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributeNames(String ... userAttributeNames) {
            this.userAttributeNames(Arrays.asList(userAttributeNames));
            return this;
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteUserAttributesRequest build() {
            return new DeleteUserAttributesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteUserAttributesRequest> {
        public Builder userAttributeNames(Collection<String> var1);

        public Builder userAttributeNames(String ... var1);

        public Builder accessToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

