/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApplicationRevisionRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, GetApplicationRevisionRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationName").getter(GetApplicationRevisionRequest.getter(GetApplicationRevisionRequest::applicationName)).setter(GetApplicationRevisionRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()}).build();
    private static final SdkField<RevisionLocation> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("revision").getter(GetApplicationRevisionRequest.getter(GetApplicationRevisionRequest::revision)).setter(GetApplicationRevisionRequest.setter(Builder::revision)).constructor(RevisionLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, REVISION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationName", APPLICATION_NAME_FIELD);
            this.put("revision", REVISION_FIELD);
        }
    });
    private final String applicationName;
    private final RevisionLocation revision;

    private GetApplicationRevisionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.revision = builder.revision;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final RevisionLocation revision() {
        return this.revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationRevisionRequest)) {
            return false;
        }
        GetApplicationRevisionRequest other = (GetApplicationRevisionRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.revision(), other.revision());
    }

    public final String toString() {
        return ToString.builder((String)"GetApplicationRevisionRequest").add("ApplicationName", (Object)this.applicationName()).add("Revision", (Object)this.revision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationRevisionRequest, T> g) {
        return obj -> g.apply((GetApplicationRevisionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private RevisionLocation revision;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationRevisionRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.revision(model.revision);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final RevisionLocation.Builder getRevision() {
            return this.revision != null ? this.revision.toBuilder() : null;
        }

        public final void setRevision(RevisionLocation.BuilderImpl revision) {
            this.revision = revision != null ? revision.build() : null;
        }

        @Override
        public final Builder revision(RevisionLocation revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetApplicationRevisionRequest build() {
            return new GetApplicationRevisionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetApplicationRevisionRequest> {
        public Builder applicationName(String var1);

        public Builder revision(RevisionLocation var1);

        default public Builder revision(Consumer<RevisionLocation.Builder> revision) {
            return this.revision((RevisionLocation)((RevisionLocation.Builder)RevisionLocation.builder().applyMutation(revision)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

