/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystAsyncClient;
import software.amazon.awssdk.services.codecatalyst.internal.UserAgentUtils;
import software.amazon.awssdk.services.codecatalyst.model.ListWorkflowRunsRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListWorkflowRunsResponse;
import software.amazon.awssdk.services.codecatalyst.model.WorkflowRunSummary;

public class ListWorkflowRunsPublisher
implements SdkPublisher<ListWorkflowRunsResponse> {
    private final CodeCatalystAsyncClient client;
    private final ListWorkflowRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkflowRunsPublisher(CodeCatalystAsyncClient client, ListWorkflowRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkflowRunsPublisher(CodeCatalystAsyncClient client, ListWorkflowRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkflowRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkflowRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkflowRunSummary> items() {
        Function<ListWorkflowRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkflowRunsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkflowRunsResponseFetcher
    implements AsyncPageFetcher<ListWorkflowRunsResponse> {
        private ListWorkflowRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkflowRunsResponse> nextPage(ListWorkflowRunsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowRunsPublisher.this.client.listWorkflowRuns(ListWorkflowRunsPublisher.this.firstRequest);
            }
            return ListWorkflowRunsPublisher.this.client.listWorkflowRuns((ListWorkflowRunsRequest)((Object)ListWorkflowRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

