/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystClient;
import software.amazon.awssdk.services.codecatalyst.internal.UserAgentUtils;
import software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionSummary;
import software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentSessionsRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentSessionsResponse;

public class ListDevEnvironmentSessionsIterable
implements SdkIterable<ListDevEnvironmentSessionsResponse> {
    private final CodeCatalystClient client;
    private final ListDevEnvironmentSessionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDevEnvironmentSessionsIterable(CodeCatalystClient client, ListDevEnvironmentSessionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDevEnvironmentSessionsResponseFetcher();
    }

    public Iterator<ListDevEnvironmentSessionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DevEnvironmentSessionSummary> items() {
        Function<ListDevEnvironmentSessionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDevEnvironmentSessionsResponseFetcher
    implements SyncPageFetcher<ListDevEnvironmentSessionsResponse> {
        private ListDevEnvironmentSessionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDevEnvironmentSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDevEnvironmentSessionsResponse nextPage(ListDevEnvironmentSessionsResponse previousPage) {
            if (previousPage == null) {
                return ListDevEnvironmentSessionsIterable.this.client.listDevEnvironmentSessions(ListDevEnvironmentSessionsIterable.this.firstRequest);
            }
            return ListDevEnvironmentSessionsIterable.this.client.listDevEnvironmentSessions((ListDevEnvironmentSessionsRequest)((Object)ListDevEnvironmentSessionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

