/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeartifact.CodeartifactClient;
import software.amazon.awssdk.services.codeartifact.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeartifact.model.AssociatedPackage;
import software.amazon.awssdk.services.codeartifact.model.ListAssociatedPackagesRequest;
import software.amazon.awssdk.services.codeartifact.model.ListAssociatedPackagesResponse;

public class ListAssociatedPackagesIterable
implements SdkIterable<ListAssociatedPackagesResponse> {
    private final CodeartifactClient client;
    private final ListAssociatedPackagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssociatedPackagesIterable(CodeartifactClient client, ListAssociatedPackagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssociatedPackagesResponseFetcher();
    }

    public Iterator<ListAssociatedPackagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssociatedPackage> packages() {
        Function<ListAssociatedPackagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.packages() != null) {
                return response.packages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssociatedPackagesResponseFetcher
    implements SyncPageFetcher<ListAssociatedPackagesResponse> {
        private ListAssociatedPackagesResponseFetcher() {
        }

        public boolean hasNextPage(ListAssociatedPackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssociatedPackagesResponse nextPage(ListAssociatedPackagesResponse previousPage) {
            if (previousPage == null) {
                return ListAssociatedPackagesIterable.this.client.listAssociatedPackages(ListAssociatedPackagesIterable.this.firstRequest);
            }
            return ListAssociatedPackagesIterable.this.client.listAssociatedPackages((ListAssociatedPackagesRequest)((Object)ListAssociatedPackagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

