/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilteredLogEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilteredLogEvent> {
    private static final SdkField<String> LOG_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logStreamName").getter(FilteredLogEvent.getter(FilteredLogEvent::logStreamName)).setter(FilteredLogEvent.setter(Builder::logStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamName").build()}).build();
    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("timestamp").getter(FilteredLogEvent.getter(FilteredLogEvent::timestamp)).setter(FilteredLogEvent.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(FilteredLogEvent.getter(FilteredLogEvent::message)).setter(FilteredLogEvent.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<Long> INGESTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ingestionTime").getter(FilteredLogEvent.getter(FilteredLogEvent::ingestionTime)).setter(FilteredLogEvent.setter(Builder::ingestionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionTime").build()}).build();
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(FilteredLogEvent.getter(FilteredLogEvent::eventId)).setter(FilteredLogEvent.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_STREAM_NAME_FIELD, TIMESTAMP_FIELD, MESSAGE_FIELD, INGESTION_TIME_FIELD, EVENT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("logStreamName", LOG_STREAM_NAME_FIELD);
            this.put("timestamp", TIMESTAMP_FIELD);
            this.put("message", MESSAGE_FIELD);
            this.put("ingestionTime", INGESTION_TIME_FIELD);
            this.put("eventId", EVENT_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String logStreamName;
    private final Long timestamp;
    private final String message;
    private final Long ingestionTime;
    private final String eventId;

    private FilteredLogEvent(BuilderImpl builder) {
        this.logStreamName = builder.logStreamName;
        this.timestamp = builder.timestamp;
        this.message = builder.message;
        this.ingestionTime = builder.ingestionTime;
        this.eventId = builder.eventId;
    }

    public final String logStreamName() {
        return this.logStreamName;
    }

    public final Long timestamp() {
        return this.timestamp;
    }

    public final String message() {
        return this.message;
    }

    public final Long ingestionTime() {
        return this.ingestionTime;
    }

    public final String eventId() {
        return this.eventId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilteredLogEvent)) {
            return false;
        }
        FilteredLogEvent other = (FilteredLogEvent)obj;
        return Objects.equals(this.logStreamName(), other.logStreamName()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.ingestionTime(), other.ingestionTime()) && Objects.equals(this.eventId(), other.eventId());
    }

    public final String toString() {
        return ToString.builder((String)"FilteredLogEvent").add("LogStreamName", (Object)this.logStreamName()).add("Timestamp", (Object)this.timestamp()).add("Message", (Object)this.message()).add("IngestionTime", (Object)this.ingestionTime()).add("EventId", (Object)this.eventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logStreamName": {
                return Optional.ofNullable(clazz.cast(this.logStreamName()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "ingestionTime": {
                return Optional.ofNullable(clazz.cast(this.ingestionTime()));
            }
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FilteredLogEvent, T> g) {
        return obj -> g.apply((FilteredLogEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logStreamName;
        private Long timestamp;
        private String message;
        private Long ingestionTime;
        private String eventId;

        private BuilderImpl() {
        }

        private BuilderImpl(FilteredLogEvent model) {
            this.logStreamName(model.logStreamName);
            this.timestamp(model.timestamp);
            this.message(model.message);
            this.ingestionTime(model.ingestionTime);
            this.eventId(model.eventId);
        }

        public final String getLogStreamName() {
            return this.logStreamName;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final Long getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Long getIngestionTime() {
            return this.ingestionTime;
        }

        public final void setIngestionTime(Long ingestionTime) {
            this.ingestionTime = ingestionTime;
        }

        @Override
        public final Builder ingestionTime(Long ingestionTime) {
            this.ingestionTime = ingestionTime;
            return this;
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public FilteredLogEvent build() {
            return new FilteredLogEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilteredLogEvent> {
        public Builder logStreamName(String var1);

        public Builder timestamp(Long var1);

        public Builder message(String var1);

        public Builder ingestionTime(Long var1);

        public Builder eventId(String var1);
    }
}

