/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.EventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaFunctionAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaFunctionAssociation> {
    private static final SdkField<String> LAMBDA_FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LambdaFunctionARN").getter(LambdaFunctionAssociation.getter(LambdaFunctionAssociation::lambdaFunctionARN)).setter(LambdaFunctionAssociation.setter(Builder::lambdaFunctionARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctionARN").unmarshallLocationName("LambdaFunctionARN").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventType").getter(LambdaFunctionAssociation.getter(LambdaFunctionAssociation::eventTypeAsString)).setter(LambdaFunctionAssociation.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").unmarshallLocationName("EventType").build()}).build();
    private static final SdkField<Boolean> INCLUDE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeBody").getter(LambdaFunctionAssociation.getter(LambdaFunctionAssociation::includeBody)).setter(LambdaFunctionAssociation.setter(Builder::includeBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeBody").unmarshallLocationName("IncludeBody").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_FUNCTION_ARN_FIELD, EVENT_TYPE_FIELD, INCLUDE_BODY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LambdaFunctionARN", LAMBDA_FUNCTION_ARN_FIELD);
            this.put("EventType", EVENT_TYPE_FIELD);
            this.put("IncludeBody", INCLUDE_BODY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String lambdaFunctionARN;
    private final String eventType;
    private final Boolean includeBody;

    private LambdaFunctionAssociation(BuilderImpl builder) {
        this.lambdaFunctionARN = builder.lambdaFunctionARN;
        this.eventType = builder.eventType;
        this.includeBody = builder.includeBody;
    }

    public final String lambdaFunctionARN() {
        return this.lambdaFunctionARN;
    }

    public final EventType eventType() {
        return EventType.fromValue(this.eventType);
    }

    public final String eventTypeAsString() {
        return this.eventType;
    }

    public final Boolean includeBody() {
        return this.includeBody;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeBody());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionAssociation)) {
            return false;
        }
        LambdaFunctionAssociation other = (LambdaFunctionAssociation)obj;
        return Objects.equals(this.lambdaFunctionARN(), other.lambdaFunctionARN()) && Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.includeBody(), other.includeBody());
    }

    public final String toString() {
        return ToString.builder((String)"LambdaFunctionAssociation").add("LambdaFunctionARN", (Object)this.lambdaFunctionARN()).add("EventType", (Object)this.eventTypeAsString()).add("IncludeBody", (Object)this.includeBody()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LambdaFunctionARN": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionARN()));
            }
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "IncludeBody": {
                return Optional.ofNullable(clazz.cast(this.includeBody()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionAssociation, T> g) {
        return obj -> g.apply((LambdaFunctionAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lambdaFunctionARN;
        private String eventType;
        private Boolean includeBody;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionAssociation model) {
            this.lambdaFunctionARN(model.lambdaFunctionARN);
            this.eventType(model.eventType);
            this.includeBody(model.includeBody);
        }

        public final String getLambdaFunctionARN() {
            return this.lambdaFunctionARN;
        }

        public final void setLambdaFunctionARN(String lambdaFunctionARN) {
            this.lambdaFunctionARN = lambdaFunctionARN;
        }

        @Override
        public final Builder lambdaFunctionARN(String lambdaFunctionARN) {
            this.lambdaFunctionARN = lambdaFunctionARN;
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final Boolean getIncludeBody() {
            return this.includeBody;
        }

        public final void setIncludeBody(Boolean includeBody) {
            this.includeBody = includeBody;
        }

        @Override
        public final Builder includeBody(Boolean includeBody) {
            this.includeBody = includeBody;
            return this;
        }

        public LambdaFunctionAssociation build() {
            return new LambdaFunctionAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaFunctionAssociation> {
        public Builder lambdaFunctionARN(String var1);

        public Builder eventType(String var1);

        public Builder eventType(EventType var1);

        public Builder includeBody(Boolean var1);
    }
}

