/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ObjectType {
    NODE("NODE"),
    LEAF_NODE("LEAF_NODE"),
    POLICY("POLICY"),
    INDEX("INDEX"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ObjectType> VALUE_MAP;
    private final String value;

    private ObjectType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ObjectType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ObjectType> knownValues() {
        EnumSet<ObjectType> knownValues = EnumSet.allOf(ObjectType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ObjectType.class, ObjectType::toString);
    }
}

