/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkmediapipelines.ChimeSdkMediaPipelinesAsyncClient;
import software.amazon.awssdk.services.chimesdkmediapipelines.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesResponse;

public class ListMediaPipelinesPublisher
implements SdkPublisher<ListMediaPipelinesResponse> {
    private final ChimeSdkMediaPipelinesAsyncClient client;
    private final ListMediaPipelinesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMediaPipelinesPublisher(ChimeSdkMediaPipelinesAsyncClient client, ListMediaPipelinesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMediaPipelinesPublisher(ChimeSdkMediaPipelinesAsyncClient client, ListMediaPipelinesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMediaPipelinesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMediaPipelinesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMediaPipelinesResponseFetcher
    implements AsyncPageFetcher<ListMediaPipelinesResponse> {
        private ListMediaPipelinesResponseFetcher() {
        }

        public boolean hasNextPage(ListMediaPipelinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMediaPipelinesResponse> nextPage(ListMediaPipelinesResponse previousPage) {
            if (previousPage == null) {
                return ListMediaPipelinesPublisher.this.client.listMediaPipelines(ListMediaPipelinesPublisher.this.firstRequest);
            }
            return ListMediaPipelinesPublisher.this.client.listMediaPipelines((ListMediaPipelinesRequest)((Object)ListMediaPipelinesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

