/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.CustomizedMetricSpecification;
import software.amazon.awssdk.services.autoscaling.model.PredefinedMetricSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetTrackingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetTrackingConfiguration> {
    private static final SdkField<PredefinedMetricSpecification> PREDEFINED_METRIC_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PredefinedMetricSpecification").getter(TargetTrackingConfiguration.getter(TargetTrackingConfiguration::predefinedMetricSpecification)).setter(TargetTrackingConfiguration.setter(Builder::predefinedMetricSpecification)).constructor(PredefinedMetricSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedMetricSpecification").build()}).build();
    private static final SdkField<CustomizedMetricSpecification> CUSTOMIZED_METRIC_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomizedMetricSpecification").getter(TargetTrackingConfiguration.getter(TargetTrackingConfiguration::customizedMetricSpecification)).setter(TargetTrackingConfiguration.setter(Builder::customizedMetricSpecification)).constructor(CustomizedMetricSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomizedMetricSpecification").build()}).build();
    private static final SdkField<Double> TARGET_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TargetValue").getter(TargetTrackingConfiguration.getter(TargetTrackingConfiguration::targetValue)).setter(TargetTrackingConfiguration.setter(Builder::targetValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetValue").build()}).build();
    private static final SdkField<Boolean> DISABLE_SCALE_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableScaleIn").getter(TargetTrackingConfiguration.getter(TargetTrackingConfiguration::disableScaleIn)).setter(TargetTrackingConfiguration.setter(Builder::disableScaleIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableScaleIn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDEFINED_METRIC_SPECIFICATION_FIELD, CUSTOMIZED_METRIC_SPECIFICATION_FIELD, TARGET_VALUE_FIELD, DISABLE_SCALE_IN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PredefinedMetricSpecification", PREDEFINED_METRIC_SPECIFICATION_FIELD);
            this.put("CustomizedMetricSpecification", CUSTOMIZED_METRIC_SPECIFICATION_FIELD);
            this.put("TargetValue", TARGET_VALUE_FIELD);
            this.put("DisableScaleIn", DISABLE_SCALE_IN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final PredefinedMetricSpecification predefinedMetricSpecification;
    private final CustomizedMetricSpecification customizedMetricSpecification;
    private final Double targetValue;
    private final Boolean disableScaleIn;

    private TargetTrackingConfiguration(BuilderImpl builder) {
        this.predefinedMetricSpecification = builder.predefinedMetricSpecification;
        this.customizedMetricSpecification = builder.customizedMetricSpecification;
        this.targetValue = builder.targetValue;
        this.disableScaleIn = builder.disableScaleIn;
    }

    public final PredefinedMetricSpecification predefinedMetricSpecification() {
        return this.predefinedMetricSpecification;
    }

    public final CustomizedMetricSpecification customizedMetricSpecification() {
        return this.customizedMetricSpecification;
    }

    public final Double targetValue() {
        return this.targetValue;
    }

    public final Boolean disableScaleIn() {
        return this.disableScaleIn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.predefinedMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.customizedMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableScaleIn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTrackingConfiguration)) {
            return false;
        }
        TargetTrackingConfiguration other = (TargetTrackingConfiguration)obj;
        return Objects.equals(this.predefinedMetricSpecification(), other.predefinedMetricSpecification()) && Objects.equals(this.customizedMetricSpecification(), other.customizedMetricSpecification()) && Objects.equals(this.targetValue(), other.targetValue()) && Objects.equals(this.disableScaleIn(), other.disableScaleIn());
    }

    public final String toString() {
        return ToString.builder((String)"TargetTrackingConfiguration").add("PredefinedMetricSpecification", (Object)this.predefinedMetricSpecification()).add("CustomizedMetricSpecification", (Object)this.customizedMetricSpecification()).add("TargetValue", (Object)this.targetValue()).add("DisableScaleIn", (Object)this.disableScaleIn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PredefinedMetricSpecification": {
                return Optional.ofNullable(clazz.cast(this.predefinedMetricSpecification()));
            }
            case "CustomizedMetricSpecification": {
                return Optional.ofNullable(clazz.cast(this.customizedMetricSpecification()));
            }
            case "TargetValue": {
                return Optional.ofNullable(clazz.cast(this.targetValue()));
            }
            case "DisableScaleIn": {
                return Optional.ofNullable(clazz.cast(this.disableScaleIn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TargetTrackingConfiguration, T> g) {
        return obj -> g.apply((TargetTrackingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PredefinedMetricSpecification predefinedMetricSpecification;
        private CustomizedMetricSpecification customizedMetricSpecification;
        private Double targetValue;
        private Boolean disableScaleIn;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetTrackingConfiguration model) {
            this.predefinedMetricSpecification(model.predefinedMetricSpecification);
            this.customizedMetricSpecification(model.customizedMetricSpecification);
            this.targetValue(model.targetValue);
            this.disableScaleIn(model.disableScaleIn);
        }

        public final PredefinedMetricSpecification.Builder getPredefinedMetricSpecification() {
            return this.predefinedMetricSpecification != null ? this.predefinedMetricSpecification.toBuilder() : null;
        }

        public final void setPredefinedMetricSpecification(PredefinedMetricSpecification.BuilderImpl predefinedMetricSpecification) {
            this.predefinedMetricSpecification = predefinedMetricSpecification != null ? predefinedMetricSpecification.build() : null;
        }

        @Override
        public final Builder predefinedMetricSpecification(PredefinedMetricSpecification predefinedMetricSpecification) {
            this.predefinedMetricSpecification = predefinedMetricSpecification;
            return this;
        }

        public final CustomizedMetricSpecification.Builder getCustomizedMetricSpecification() {
            return this.customizedMetricSpecification != null ? this.customizedMetricSpecification.toBuilder() : null;
        }

        public final void setCustomizedMetricSpecification(CustomizedMetricSpecification.BuilderImpl customizedMetricSpecification) {
            this.customizedMetricSpecification = customizedMetricSpecification != null ? customizedMetricSpecification.build() : null;
        }

        @Override
        public final Builder customizedMetricSpecification(CustomizedMetricSpecification customizedMetricSpecification) {
            this.customizedMetricSpecification = customizedMetricSpecification;
            return this;
        }

        public final Double getTargetValue() {
            return this.targetValue;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public final Boolean getDisableScaleIn() {
            return this.disableScaleIn;
        }

        public final void setDisableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
        }

        @Override
        public final Builder disableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
            return this;
        }

        public TargetTrackingConfiguration build() {
            return new TargetTrackingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetTrackingConfiguration> {
        public Builder predefinedMetricSpecification(PredefinedMetricSpecification var1);

        default public Builder predefinedMetricSpecification(Consumer<PredefinedMetricSpecification.Builder> predefinedMetricSpecification) {
            return this.predefinedMetricSpecification((PredefinedMetricSpecification)((PredefinedMetricSpecification.Builder)PredefinedMetricSpecification.builder().applyMutation(predefinedMetricSpecification)).build());
        }

        public Builder customizedMetricSpecification(CustomizedMetricSpecification var1);

        default public Builder customizedMetricSpecification(Consumer<CustomizedMetricSpecification.Builder> customizedMetricSpecification) {
            return this.customizedMetricSpecification((CustomizedMetricSpecification)((CustomizedMetricSpecification.Builder)CustomizedMetricSpecification.builder().applyMutation(customizedMetricSpecification)).build());
        }

        public Builder targetValue(Double var1);

        public Builder disableScaleIn(Boolean var1);
    }
}

