/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PredefinedMetricPairType {
    ASGCPU_UTILIZATION("ASGCPUUtilization"),
    ASG_NETWORK_IN("ASGNetworkIn"),
    ASG_NETWORK_OUT("ASGNetworkOut"),
    ALB_REQUEST_COUNT("ALBRequestCount"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PredefinedMetricPairType> VALUE_MAP;
    private final String value;

    private PredefinedMetricPairType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PredefinedMetricPairType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PredefinedMetricPairType> knownValues() {
        EnumSet<PredefinedMetricPairType> knownValues = EnumSet.allOf(PredefinedMetricPairType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PredefinedMetricPairType.class, PredefinedMetricPairType::toString);
    }
}

