/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.ScalingActivityStatusCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Activity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Activity> {
    private static final SdkField<String> ACTIVITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivityId").getter(Activity.getter(Activity::activityId)).setter(Activity.setter(Builder::activityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityId").build()}).build();
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupName").getter(Activity.getter(Activity::autoScalingGroupName)).setter(Activity.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Activity.getter(Activity::description)).setter(Activity.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cause").getter(Activity.getter(Activity::cause)).setter(Activity.setter(Builder::cause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cause").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(Activity.getter(Activity::startTime)).setter(Activity.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(Activity.getter(Activity::endTime)).setter(Activity.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusCode").getter(Activity.getter(Activity::statusCodeAsString)).setter(Activity.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(Activity.getter(Activity::statusMessage)).setter(Activity.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Integer> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Progress").getter(Activity.getter(Activity::progress)).setter(Activity.setter(Builder::progress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").build()}).build();
    private static final SdkField<String> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Details").getter(Activity.getter(Activity::details)).setter(Activity.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()}).build();
    private static final SdkField<String> AUTO_SCALING_GROUP_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupState").getter(Activity.getter(Activity::autoScalingGroupState)).setter(Activity.setter(Builder::autoScalingGroupState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupState").build()}).build();
    private static final SdkField<String> AUTO_SCALING_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupARN").getter(Activity.getter(Activity::autoScalingGroupARN)).setter(Activity.setter(Builder::autoScalingGroupARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_ID_FIELD, AUTO_SCALING_GROUP_NAME_FIELD, DESCRIPTION_FIELD, CAUSE_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, PROGRESS_FIELD, DETAILS_FIELD, AUTO_SCALING_GROUP_STATE_FIELD, AUTO_SCALING_GROUP_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ActivityId", ACTIVITY_ID_FIELD);
            this.put("AutoScalingGroupName", AUTO_SCALING_GROUP_NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Cause", CAUSE_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("EndTime", END_TIME_FIELD);
            this.put("StatusCode", STATUS_CODE_FIELD);
            this.put("StatusMessage", STATUS_MESSAGE_FIELD);
            this.put("Progress", PROGRESS_FIELD);
            this.put("Details", DETAILS_FIELD);
            this.put("AutoScalingGroupState", AUTO_SCALING_GROUP_STATE_FIELD);
            this.put("AutoScalingGroupARN", AUTO_SCALING_GROUP_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String activityId;
    private final String autoScalingGroupName;
    private final String description;
    private final String cause;
    private final Instant startTime;
    private final Instant endTime;
    private final String statusCode;
    private final String statusMessage;
    private final Integer progress;
    private final String details;
    private final String autoScalingGroupState;
    private final String autoScalingGroupARN;

    private Activity(BuilderImpl builder) {
        this.activityId = builder.activityId;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.description = builder.description;
        this.cause = builder.cause;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.progress = builder.progress;
        this.details = builder.details;
        this.autoScalingGroupState = builder.autoScalingGroupState;
        this.autoScalingGroupARN = builder.autoScalingGroupARN;
    }

    public final String activityId() {
        return this.activityId;
    }

    public final String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public final String description() {
        return this.description;
    }

    public final String cause() {
        return this.cause;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final ScalingActivityStatusCode statusCode() {
        return ScalingActivityStatusCode.fromValue(this.statusCode);
    }

    public final String statusCodeAsString() {
        return this.statusCode;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Integer progress() {
        return this.progress;
    }

    public final String details() {
        return this.details;
    }

    public final String autoScalingGroupState() {
        return this.autoScalingGroupState;
    }

    public final String autoScalingGroupARN() {
        return this.autoScalingGroupARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.cause());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupState());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Activity)) {
            return false;
        }
        Activity other = (Activity)obj;
        return Objects.equals(this.activityId(), other.activityId()) && Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.cause(), other.cause()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.details(), other.details()) && Objects.equals(this.autoScalingGroupState(), other.autoScalingGroupState()) && Objects.equals(this.autoScalingGroupARN(), other.autoScalingGroupARN());
    }

    public final String toString() {
        return ToString.builder((String)"Activity").add("ActivityId", (Object)this.activityId()).add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("Description", (Object)this.description()).add("Cause", (Object)this.cause()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("StatusCode", (Object)this.statusCodeAsString()).add("StatusMessage", (Object)this.statusMessage()).add("Progress", (Object)this.progress()).add("Details", (Object)this.details()).add("AutoScalingGroupState", (Object)this.autoScalingGroupState()).add("AutoScalingGroupARN", (Object)this.autoScalingGroupARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivityId": {
                return Optional.ofNullable(clazz.cast(this.activityId()));
            }
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Cause": {
                return Optional.ofNullable(clazz.cast(this.cause()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "Progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
            case "AutoScalingGroupState": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupState()));
            }
            case "AutoScalingGroupARN": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Activity, T> g) {
        return obj -> g.apply((Activity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String activityId;
        private String autoScalingGroupName;
        private String description;
        private String cause;
        private Instant startTime;
        private Instant endTime;
        private String statusCode;
        private String statusMessage;
        private Integer progress;
        private String details;
        private String autoScalingGroupState;
        private String autoScalingGroupARN;

        private BuilderImpl() {
        }

        private BuilderImpl(Activity model) {
            this.activityId(model.activityId);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.description(model.description);
            this.cause(model.cause);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.statusCode(model.statusCode);
            this.statusMessage(model.statusMessage);
            this.progress(model.progress);
            this.details(model.details);
            this.autoScalingGroupState(model.autoScalingGroupState);
            this.autoScalingGroupARN(model.autoScalingGroupARN);
        }

        public final String getActivityId() {
            return this.activityId;
        }

        public final void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        @Override
        public final Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCause() {
            return this.cause;
        }

        public final void setCause(String cause) {
            this.cause = cause;
        }

        @Override
        public final Builder cause(String cause) {
            this.cause = cause;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(ScalingActivityStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Integer getProgress() {
            return this.progress;
        }

        public final void setProgress(Integer progress) {
            this.progress = progress;
        }

        @Override
        public final Builder progress(Integer progress) {
            this.progress = progress;
            return this;
        }

        public final String getDetails() {
            return this.details;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final String getAutoScalingGroupState() {
            return this.autoScalingGroupState;
        }

        public final void setAutoScalingGroupState(String autoScalingGroupState) {
            this.autoScalingGroupState = autoScalingGroupState;
        }

        @Override
        public final Builder autoScalingGroupState(String autoScalingGroupState) {
            this.autoScalingGroupState = autoScalingGroupState;
            return this;
        }

        public final String getAutoScalingGroupARN() {
            return this.autoScalingGroupARN;
        }

        public final void setAutoScalingGroupARN(String autoScalingGroupARN) {
            this.autoScalingGroupARN = autoScalingGroupARN;
        }

        @Override
        public final Builder autoScalingGroupARN(String autoScalingGroupARN) {
            this.autoScalingGroupARN = autoScalingGroupARN;
            return this;
        }

        public Activity build() {
            return new Activity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Activity> {
        public Builder activityId(String var1);

        public Builder autoScalingGroupName(String var1);

        public Builder description(String var1);

        public Builder cause(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder statusCode(String var1);

        public Builder statusCode(ScalingActivityStatusCode var1);

        public Builder statusMessage(String var1);

        public Builder progress(Integer var1);

        public Builder details(String var1);

        public Builder autoScalingGroupState(String var1);

        public Builder autoScalingGroupARN(String var1);
    }
}

