/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apprunner.model.Runtime;
import software.amazon.awssdk.services.apprunner.model.RuntimeEnvironmentSecretsCopier;
import software.amazon.awssdk.services.apprunner.model.RuntimeEnvironmentVariablesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeConfigurationValues
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeConfigurationValues> {
    private static final SdkField<String> RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Runtime").getter(CodeConfigurationValues.getter(CodeConfigurationValues::runtimeAsString)).setter(CodeConfigurationValues.setter(Builder::runtime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runtime").build()}).build();
    private static final SdkField<String> BUILD_COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BuildCommand").getter(CodeConfigurationValues.getter(CodeConfigurationValues::buildCommand)).setter(CodeConfigurationValues.setter(Builder::buildCommand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuildCommand").build()}).build();
    private static final SdkField<String> START_COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartCommand").getter(CodeConfigurationValues.getter(CodeConfigurationValues::startCommand)).setter(CodeConfigurationValues.setter(Builder::startCommand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartCommand").build()}).build();
    private static final SdkField<String> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Port").getter(CodeConfigurationValues.getter(CodeConfigurationValues::port)).setter(CodeConfigurationValues.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<Map<String, String>> RUNTIME_ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RuntimeEnvironmentVariables").getter(CodeConfigurationValues.getter(CodeConfigurationValues::runtimeEnvironmentVariables)).setter(CodeConfigurationValues.setter(Builder::runtimeEnvironmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeEnvironmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> RUNTIME_ENVIRONMENT_SECRETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RuntimeEnvironmentSecrets").getter(CodeConfigurationValues.getter(CodeConfigurationValues::runtimeEnvironmentSecrets)).setter(CodeConfigurationValues.setter(Builder::runtimeEnvironmentSecrets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeEnvironmentSecrets").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNTIME_FIELD, BUILD_COMMAND_FIELD, START_COMMAND_FIELD, PORT_FIELD, RUNTIME_ENVIRONMENT_VARIABLES_FIELD, RUNTIME_ENVIRONMENT_SECRETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Runtime", RUNTIME_FIELD);
            this.put("BuildCommand", BUILD_COMMAND_FIELD);
            this.put("StartCommand", START_COMMAND_FIELD);
            this.put("Port", PORT_FIELD);
            this.put("RuntimeEnvironmentVariables", RUNTIME_ENVIRONMENT_VARIABLES_FIELD);
            this.put("RuntimeEnvironmentSecrets", RUNTIME_ENVIRONMENT_SECRETS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String runtime;
    private final String buildCommand;
    private final String startCommand;
    private final String port;
    private final Map<String, String> runtimeEnvironmentVariables;
    private final Map<String, String> runtimeEnvironmentSecrets;

    private CodeConfigurationValues(BuilderImpl builder) {
        this.runtime = builder.runtime;
        this.buildCommand = builder.buildCommand;
        this.startCommand = builder.startCommand;
        this.port = builder.port;
        this.runtimeEnvironmentVariables = builder.runtimeEnvironmentVariables;
        this.runtimeEnvironmentSecrets = builder.runtimeEnvironmentSecrets;
    }

    public final Runtime runtime() {
        return Runtime.fromValue(this.runtime);
    }

    public final String runtimeAsString() {
        return this.runtime;
    }

    public final String buildCommand() {
        return this.buildCommand;
    }

    public final String startCommand() {
        return this.startCommand;
    }

    public final String port() {
        return this.port;
    }

    public final boolean hasRuntimeEnvironmentVariables() {
        return this.runtimeEnvironmentVariables != null && !(this.runtimeEnvironmentVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> runtimeEnvironmentVariables() {
        return this.runtimeEnvironmentVariables;
    }

    public final boolean hasRuntimeEnvironmentSecrets() {
        return this.runtimeEnvironmentSecrets != null && !(this.runtimeEnvironmentSecrets instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> runtimeEnvironmentSecrets() {
        return this.runtimeEnvironmentSecrets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildCommand());
        hashCode = 31 * hashCode + Objects.hashCode(this.startCommand());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuntimeEnvironmentVariables() ? this.runtimeEnvironmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuntimeEnvironmentSecrets() ? this.runtimeEnvironmentSecrets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeConfigurationValues)) {
            return false;
        }
        CodeConfigurationValues other = (CodeConfigurationValues)obj;
        return Objects.equals(this.runtimeAsString(), other.runtimeAsString()) && Objects.equals(this.buildCommand(), other.buildCommand()) && Objects.equals(this.startCommand(), other.startCommand()) && Objects.equals(this.port(), other.port()) && this.hasRuntimeEnvironmentVariables() == other.hasRuntimeEnvironmentVariables() && Objects.equals(this.runtimeEnvironmentVariables(), other.runtimeEnvironmentVariables()) && this.hasRuntimeEnvironmentSecrets() == other.hasRuntimeEnvironmentSecrets() && Objects.equals(this.runtimeEnvironmentSecrets(), other.runtimeEnvironmentSecrets());
    }

    public final String toString() {
        return ToString.builder((String)"CodeConfigurationValues").add("Runtime", (Object)this.runtimeAsString()).add("BuildCommand", (Object)(this.buildCommand() == null ? null : "*** Sensitive Data Redacted ***")).add("StartCommand", (Object)(this.startCommand() == null ? null : "*** Sensitive Data Redacted ***")).add("Port", (Object)this.port()).add("RuntimeEnvironmentVariables", (Object)(this.runtimeEnvironmentVariables() == null ? null : "*** Sensitive Data Redacted ***")).add("RuntimeEnvironmentSecrets", (Object)(this.runtimeEnvironmentSecrets() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Runtime": {
                return Optional.ofNullable(clazz.cast(this.runtimeAsString()));
            }
            case "BuildCommand": {
                return Optional.ofNullable(clazz.cast(this.buildCommand()));
            }
            case "StartCommand": {
                return Optional.ofNullable(clazz.cast(this.startCommand()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "RuntimeEnvironmentVariables": {
                return Optional.ofNullable(clazz.cast(this.runtimeEnvironmentVariables()));
            }
            case "RuntimeEnvironmentSecrets": {
                return Optional.ofNullable(clazz.cast(this.runtimeEnvironmentSecrets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CodeConfigurationValues, T> g) {
        return obj -> g.apply((CodeConfigurationValues)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String runtime;
        private String buildCommand;
        private String startCommand;
        private String port;
        private Map<String, String> runtimeEnvironmentVariables = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> runtimeEnvironmentSecrets = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CodeConfigurationValues model) {
            this.runtime(model.runtime);
            this.buildCommand(model.buildCommand);
            this.startCommand(model.startCommand);
            this.port(model.port);
            this.runtimeEnvironmentVariables(model.runtimeEnvironmentVariables);
            this.runtimeEnvironmentSecrets(model.runtimeEnvironmentSecrets);
        }

        public final String getRuntime() {
            return this.runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(Runtime runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        public final String getBuildCommand() {
            return this.buildCommand;
        }

        public final void setBuildCommand(String buildCommand) {
            this.buildCommand = buildCommand;
        }

        @Override
        public final Builder buildCommand(String buildCommand) {
            this.buildCommand = buildCommand;
            return this;
        }

        public final String getStartCommand() {
            return this.startCommand;
        }

        public final void setStartCommand(String startCommand) {
            this.startCommand = startCommand;
        }

        @Override
        public final Builder startCommand(String startCommand) {
            this.startCommand = startCommand;
            return this;
        }

        public final String getPort() {
            return this.port;
        }

        public final void setPort(String port) {
            this.port = port;
        }

        @Override
        public final Builder port(String port) {
            this.port = port;
            return this;
        }

        public final Map<String, String> getRuntimeEnvironmentVariables() {
            if (this.runtimeEnvironmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.runtimeEnvironmentVariables;
        }

        public final void setRuntimeEnvironmentVariables(Map<String, String> runtimeEnvironmentVariables) {
            this.runtimeEnvironmentVariables = RuntimeEnvironmentVariablesCopier.copy(runtimeEnvironmentVariables);
        }

        @Override
        public final Builder runtimeEnvironmentVariables(Map<String, String> runtimeEnvironmentVariables) {
            this.runtimeEnvironmentVariables = RuntimeEnvironmentVariablesCopier.copy(runtimeEnvironmentVariables);
            return this;
        }

        public final Map<String, String> getRuntimeEnvironmentSecrets() {
            if (this.runtimeEnvironmentSecrets instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.runtimeEnvironmentSecrets;
        }

        public final void setRuntimeEnvironmentSecrets(Map<String, String> runtimeEnvironmentSecrets) {
            this.runtimeEnvironmentSecrets = RuntimeEnvironmentSecretsCopier.copy(runtimeEnvironmentSecrets);
        }

        @Override
        public final Builder runtimeEnvironmentSecrets(Map<String, String> runtimeEnvironmentSecrets) {
            this.runtimeEnvironmentSecrets = RuntimeEnvironmentSecretsCopier.copy(runtimeEnvironmentSecrets);
            return this;
        }

        public CodeConfigurationValues build() {
            return new CodeConfigurationValues(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeConfigurationValues> {
        public Builder runtime(String var1);

        public Builder runtime(Runtime var1);

        public Builder buildCommand(String var1);

        public Builder startCommand(String var1);

        public Builder port(String var1);

        public Builder runtimeEnvironmentVariables(Map<String, String> var1);

        public Builder runtimeEnvironmentSecrets(Map<String, String> var1);
    }
}

