/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.AppflowRequest;
import software.amazon.awssdk.services.appflow.model.ConnectionMode;
import software.amazon.awssdk.services.appflow.model.ConnectorProfileConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConnectorProfileRequest
extends AppflowRequest
implements ToCopyableBuilder<Builder, UpdateConnectorProfileRequest> {
    private static final SdkField<String> CONNECTOR_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorProfileName").getter(UpdateConnectorProfileRequest.getter(UpdateConnectorProfileRequest::connectorProfileName)).setter(UpdateConnectorProfileRequest.setter(Builder::connectorProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileName").build()}).build();
    private static final SdkField<String> CONNECTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionMode").getter(UpdateConnectorProfileRequest.getter(UpdateConnectorProfileRequest::connectionModeAsString)).setter(UpdateConnectorProfileRequest.setter(Builder::connectionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionMode").build()}).build();
    private static final SdkField<ConnectorProfileConfig> CONNECTOR_PROFILE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("connectorProfileConfig").getter(UpdateConnectorProfileRequest.getter(UpdateConnectorProfileRequest::connectorProfileConfig)).setter(UpdateConnectorProfileRequest.setter(Builder::connectorProfileConfig)).constructor(ConnectorProfileConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileConfig").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateConnectorProfileRequest.getter(UpdateConnectorProfileRequest::clientToken)).setter(UpdateConnectorProfileRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_PROFILE_NAME_FIELD, CONNECTION_MODE_FIELD, CONNECTOR_PROFILE_CONFIG_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("connectorProfileName", CONNECTOR_PROFILE_NAME_FIELD);
            this.put("connectionMode", CONNECTION_MODE_FIELD);
            this.put("connectorProfileConfig", CONNECTOR_PROFILE_CONFIG_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final String connectorProfileName;
    private final String connectionMode;
    private final ConnectorProfileConfig connectorProfileConfig;
    private final String clientToken;

    private UpdateConnectorProfileRequest(BuilderImpl builder) {
        super(builder);
        this.connectorProfileName = builder.connectorProfileName;
        this.connectionMode = builder.connectionMode;
        this.connectorProfileConfig = builder.connectorProfileConfig;
        this.clientToken = builder.clientToken;
    }

    public final String connectorProfileName() {
        return this.connectorProfileName;
    }

    public final ConnectionMode connectionMode() {
        return ConnectionMode.fromValue(this.connectionMode);
    }

    public final String connectionModeAsString() {
        return this.connectionMode;
    }

    public final ConnectorProfileConfig connectorProfileConfig() {
        return this.connectorProfileConfig;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorProfileConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectorProfileRequest)) {
            return false;
        }
        UpdateConnectorProfileRequest other = (UpdateConnectorProfileRequest)((Object)obj);
        return Objects.equals(this.connectorProfileName(), other.connectorProfileName()) && Objects.equals(this.connectionModeAsString(), other.connectionModeAsString()) && Objects.equals(this.connectorProfileConfig(), other.connectorProfileConfig()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConnectorProfileRequest").add("ConnectorProfileName", (Object)this.connectorProfileName()).add("ConnectionMode", (Object)this.connectionModeAsString()).add("ConnectorProfileConfig", (Object)this.connectorProfileConfig()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorProfileName": {
                return Optional.ofNullable(clazz.cast(this.connectorProfileName()));
            }
            case "connectionMode": {
                return Optional.ofNullable(clazz.cast(this.connectionModeAsString()));
            }
            case "connectorProfileConfig": {
                return Optional.ofNullable(clazz.cast(this.connectorProfileConfig()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectorProfileRequest, T> g) {
        return obj -> g.apply((UpdateConnectorProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowRequest.BuilderImpl
    implements Builder {
        private String connectorProfileName;
        private String connectionMode;
        private ConnectorProfileConfig connectorProfileConfig;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectorProfileRequest model) {
            super(model);
            this.connectorProfileName(model.connectorProfileName);
            this.connectionMode(model.connectionMode);
            this.connectorProfileConfig(model.connectorProfileConfig);
            this.clientToken(model.clientToken);
        }

        public final String getConnectorProfileName() {
            return this.connectorProfileName;
        }

        public final void setConnectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
        }

        @Override
        public final Builder connectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        public final String getConnectionMode() {
            return this.connectionMode;
        }

        public final void setConnectionMode(String connectionMode) {
            this.connectionMode = connectionMode;
        }

        @Override
        public final Builder connectionMode(String connectionMode) {
            this.connectionMode = connectionMode;
            return this;
        }

        @Override
        public final Builder connectionMode(ConnectionMode connectionMode) {
            this.connectionMode(connectionMode == null ? null : connectionMode.toString());
            return this;
        }

        public final ConnectorProfileConfig.Builder getConnectorProfileConfig() {
            return this.connectorProfileConfig != null ? this.connectorProfileConfig.toBuilder() : null;
        }

        public final void setConnectorProfileConfig(ConnectorProfileConfig.BuilderImpl connectorProfileConfig) {
            this.connectorProfileConfig = connectorProfileConfig != null ? connectorProfileConfig.build() : null;
        }

        @Override
        public final Builder connectorProfileConfig(ConnectorProfileConfig connectorProfileConfig) {
            this.connectorProfileConfig = connectorProfileConfig;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectorProfileRequest build() {
            return new UpdateConnectorProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppflowRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConnectorProfileRequest> {
        public Builder connectorProfileName(String var1);

        public Builder connectionMode(String var1);

        public Builder connectionMode(ConnectionMode var1);

        public Builder connectorProfileConfig(ConnectorProfileConfig var1);

        default public Builder connectorProfileConfig(Consumer<ConnectorProfileConfig.Builder> connectorProfileConfig) {
            return this.connectorProfileConfig((ConnectorProfileConfig)((ConnectorProfileConfig.Builder)ConnectorProfileConfig.builder().applyMutation(connectorProfileConfig)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

