/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.ApiStage;
import software.amazon.awssdk.services.apigateway.model.ListOfApiStageCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.services.apigateway.model.QuotaSettings;
import software.amazon.awssdk.services.apigateway.model.ThrottleSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUsagePlanResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, UpdateUsagePlanResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateUsagePlanResponse.getter(UpdateUsagePlanResponse::id)).setter(UpdateUsagePlanResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateUsagePlanResponse.getter(UpdateUsagePlanResponse::name)).setter(UpdateUsagePlanResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateUsagePlanResponse.getter(UpdateUsagePlanResponse::description)).setter(UpdateUsagePlanResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<ApiStage>> API_STAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("apiStages").getter(UpdateUsagePlanResponse.getter(UpdateUsagePlanResponse::apiStages)).setter(UpdateUsagePlanResponse.setter(Builder::apiStages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiStages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApiStage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ThrottleSettings> THROTTLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("throttle").getter(UpdateUsagePlanResponse.getter(UpdateUsagePlanResponse::throttle)).setter(UpdateUsagePlanResponse.setter(Builder::throttle)).constructor(ThrottleSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throttle").build()}).build();
    private static final SdkField<QuotaSettings> QUOTA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("quota").getter(UpdateUsagePlanResponse.getter(UpdateUsagePlanResponse::quota)).setter(UpdateUsagePlanResponse.setter(Builder::quota)).constructor(QuotaSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quota").build()}).build();
    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("productCode").getter(UpdateUsagePlanResponse.getter(UpdateUsagePlanResponse::productCode)).setter(UpdateUsagePlanResponse.setter(Builder::productCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productCode").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(UpdateUsagePlanResponse.getter(UpdateUsagePlanResponse::tags)).setter(UpdateUsagePlanResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, API_STAGES_FIELD, THROTTLE_FIELD, QUOTA_FIELD, PRODUCT_CODE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("id", ID_FIELD);
            this.put("name", NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("apiStages", API_STAGES_FIELD);
            this.put("throttle", THROTTLE_FIELD);
            this.put("quota", QUOTA_FIELD);
            this.put("productCode", PRODUCT_CODE_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String id;
    private final String name;
    private final String description;
    private final List<ApiStage> apiStages;
    private final ThrottleSettings throttle;
    private final QuotaSettings quota;
    private final String productCode;
    private final Map<String, String> tags;

    private UpdateUsagePlanResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.apiStages = builder.apiStages;
        this.throttle = builder.throttle;
        this.quota = builder.quota;
        this.productCode = builder.productCode;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasApiStages() {
        return this.apiStages != null && !(this.apiStages instanceof SdkAutoConstructList);
    }

    public final List<ApiStage> apiStages() {
        return this.apiStages;
    }

    public final ThrottleSettings throttle() {
        return this.throttle;
    }

    public final QuotaSettings quota() {
        return this.quota;
    }

    public final String productCode() {
        return this.productCode;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApiStages() ? this.apiStages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.throttle());
        hashCode = 31 * hashCode + Objects.hashCode(this.quota());
        hashCode = 31 * hashCode + Objects.hashCode(this.productCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUsagePlanResponse)) {
            return false;
        }
        UpdateUsagePlanResponse other = (UpdateUsagePlanResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasApiStages() == other.hasApiStages() && Objects.equals(this.apiStages(), other.apiStages()) && Objects.equals(this.throttle(), other.throttle()) && Objects.equals(this.quota(), other.quota()) && Objects.equals(this.productCode(), other.productCode()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateUsagePlanResponse").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ApiStages", this.hasApiStages() ? this.apiStages() : null).add("Throttle", (Object)this.throttle()).add("Quota", (Object)this.quota()).add("ProductCode", (Object)this.productCode()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "apiStages": {
                return Optional.ofNullable(clazz.cast(this.apiStages()));
            }
            case "throttle": {
                return Optional.ofNullable(clazz.cast(this.throttle()));
            }
            case "quota": {
                return Optional.ofNullable(clazz.cast(this.quota()));
            }
            case "productCode": {
                return Optional.ofNullable(clazz.cast(this.productCode()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUsagePlanResponse, T> g) {
        return obj -> g.apply((UpdateUsagePlanResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private List<ApiStage> apiStages = DefaultSdkAutoConstructList.getInstance();
        private ThrottleSettings throttle;
        private QuotaSettings quota;
        private String productCode;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUsagePlanResponse model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.apiStages(model.apiStages);
            this.throttle(model.throttle);
            this.quota(model.quota);
            this.productCode(model.productCode);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<ApiStage.Builder> getApiStages() {
            List<ApiStage.Builder> result = ListOfApiStageCopier.copyToBuilder(this.apiStages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApiStages(Collection<ApiStage.BuilderImpl> apiStages) {
            this.apiStages = ListOfApiStageCopier.copyFromBuilder(apiStages);
        }

        @Override
        public final Builder apiStages(Collection<ApiStage> apiStages) {
            this.apiStages = ListOfApiStageCopier.copy(apiStages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apiStages(ApiStage ... apiStages) {
            this.apiStages(Arrays.asList(apiStages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apiStages(Consumer<ApiStage.Builder> ... apiStages) {
            this.apiStages(Stream.of(apiStages).map(c -> (ApiStage)((ApiStage.Builder)ApiStage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ThrottleSettings.Builder getThrottle() {
            return this.throttle != null ? this.throttle.toBuilder() : null;
        }

        public final void setThrottle(ThrottleSettings.BuilderImpl throttle) {
            this.throttle = throttle != null ? throttle.build() : null;
        }

        @Override
        public final Builder throttle(ThrottleSettings throttle) {
            this.throttle = throttle;
            return this;
        }

        public final QuotaSettings.Builder getQuota() {
            return this.quota != null ? this.quota.toBuilder() : null;
        }

        public final void setQuota(QuotaSettings.BuilderImpl quota) {
            this.quota = quota != null ? quota.build() : null;
        }

        @Override
        public final Builder quota(QuotaSettings quota) {
            this.quota = quota;
            return this;
        }

        public final String getProductCode() {
            return this.productCode;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        @Override
        public UpdateUsagePlanResponse build() {
            return new UpdateUsagePlanResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUsagePlanResponse> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder apiStages(Collection<ApiStage> var1);

        public Builder apiStages(ApiStage ... var1);

        public Builder apiStages(Consumer<ApiStage.Builder> ... var1);

        public Builder throttle(ThrottleSettings var1);

        default public Builder throttle(Consumer<ThrottleSettings.Builder> throttle) {
            return this.throttle((ThrottleSettings)((ThrottleSettings.Builder)ThrottleSettings.builder().applyMutation(throttle)).build());
        }

        public Builder quota(QuotaSettings var1);

        default public Builder quota(Consumer<QuotaSettings.Builder> quota) {
            return this.quota((QuotaSettings)((QuotaSettings.Builder)QuotaSettings.builder().applyMutation(quota)).build());
        }

        public Builder productCode(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

