/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amplifyuibuilder.AmplifyUiBuilderClient;
import software.amazon.awssdk.services.amplifyuibuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.amplifyuibuilder.model.Component;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse;

public class ExportComponentsIterable
implements SdkIterable<ExportComponentsResponse> {
    private final AmplifyUiBuilderClient client;
    private final ExportComponentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ExportComponentsIterable(AmplifyUiBuilderClient client, ExportComponentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ExportComponentsResponseFetcher();
    }

    public Iterator<ExportComponentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Component> entities() {
        Function<ExportComponentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.entities() != null) {
                return response.entities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ExportComponentsResponseFetcher
    implements SyncPageFetcher<ExportComponentsResponse> {
        private ExportComponentsResponseFetcher() {
        }

        public boolean hasNextPage(ExportComponentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ExportComponentsResponse nextPage(ExportComponentsResponse previousPage) {
            if (previousPage == null) {
                return ExportComponentsIterable.this.client.exportComponents(ExportComponentsIterable.this.firstRequest);
            }
            return ExportComponentsIterable.this.client.exportComponents((ExportComponentsRequest)((Object)ExportComponentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

