/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifyuibuilder.model.AmplifyUiBuilderRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.PutMetadataFlagBody;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutMetadataFlagRequest
extends AmplifyUiBuilderRequest
implements ToCopyableBuilder<Builder, PutMetadataFlagRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(PutMetadataFlagRequest.getter(PutMetadataFlagRequest::appId)).setter(PutMetadataFlagRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(PutMetadataFlagRequest.getter(PutMetadataFlagRequest::environmentName)).setter(PutMetadataFlagRequest.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentName").build()}).build();
    private static final SdkField<String> FEATURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("featureName").getter(PutMetadataFlagRequest.getter(PutMetadataFlagRequest::featureName)).setter(PutMetadataFlagRequest.setter(Builder::featureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("featureName").build()}).build();
    private static final SdkField<PutMetadataFlagBody> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("body").getter(PutMetadataFlagRequest.getter(PutMetadataFlagRequest::body)).setter(PutMetadataFlagRequest.setter(Builder::body)).constructor(PutMetadataFlagBody::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, ENVIRONMENT_NAME_FIELD, FEATURE_NAME_FIELD, BODY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("appId", APP_ID_FIELD);
            this.put("environmentName", ENVIRONMENT_NAME_FIELD);
            this.put("featureName", FEATURE_NAME_FIELD);
            this.put("body", BODY_FIELD);
        }
    });
    private final String appId;
    private final String environmentName;
    private final String featureName;
    private final PutMetadataFlagBody body;

    private PutMetadataFlagRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.environmentName = builder.environmentName;
        this.featureName = builder.featureName;
        this.body = builder.body;
    }

    public final String appId() {
        return this.appId;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final String featureName() {
        return this.featureName;
    }

    public final PutMetadataFlagBody body() {
        return this.body;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureName());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetadataFlagRequest)) {
            return false;
        }
        PutMetadataFlagRequest other = (PutMetadataFlagRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.featureName(), other.featureName()) && Objects.equals(this.body(), other.body());
    }

    public final String toString() {
        return ToString.builder((String)"PutMetadataFlagRequest").add("AppId", (Object)this.appId()).add("EnvironmentName", (Object)this.environmentName()).add("FeatureName", (Object)this.featureName()).add("Body", (Object)this.body()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "featureName": {
                return Optional.ofNullable(clazz.cast(this.featureName()));
            }
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutMetadataFlagRequest, T> g) {
        return obj -> g.apply((PutMetadataFlagRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyUiBuilderRequest.BuilderImpl
    implements Builder {
        private String appId;
        private String environmentName;
        private String featureName;
        private PutMetadataFlagBody body;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetadataFlagRequest model) {
            super(model);
            this.appId(model.appId);
            this.environmentName(model.environmentName);
            this.featureName(model.featureName);
            this.body(model.body);
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getFeatureName() {
            return this.featureName;
        }

        public final void setFeatureName(String featureName) {
            this.featureName = featureName;
        }

        @Override
        public final Builder featureName(String featureName) {
            this.featureName = featureName;
            return this;
        }

        public final PutMetadataFlagBody.Builder getBody() {
            return this.body != null ? this.body.toBuilder() : null;
        }

        public final void setBody(PutMetadataFlagBody.BuilderImpl body) {
            this.body = body != null ? body.build() : null;
        }

        @Override
        public final Builder body(PutMetadataFlagBody body) {
            this.body = body;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMetadataFlagRequest build() {
            return new PutMetadataFlagRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AmplifyUiBuilderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutMetadataFlagRequest> {
        public Builder appId(String var1);

        public Builder environmentName(String var1);

        public Builder featureName(String var1);

        public Builder body(PutMetadataFlagBody var1);

        default public Builder body(Consumer<PutMetadataFlagBody.Builder> body) {
            return this.body((PutMetadataFlagBody)((PutMetadataFlagBody.Builder)PutMetadataFlagBody.builder().applyMutation(body)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

