/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SigningAlgorithm {
    SHA256_WITHECDSA("SHA256WITHECDSA"),
    SHA384_WITHECDSA("SHA384WITHECDSA"),
    SHA512_WITHECDSA("SHA512WITHECDSA"),
    SHA256_WITHRSA("SHA256WITHRSA"),
    SHA384_WITHRSA("SHA384WITHRSA"),
    SHA512_WITHRSA("SHA512WITHRSA"),
    SM3_WITHSM2("SM3WITHSM2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SigningAlgorithm> VALUE_MAP;
    private final String value;

    private SigningAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SigningAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SigningAlgorithm> knownValues() {
        EnumSet<SigningAlgorithm> knownValues = EnumSet.allOf(SigningAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SigningAlgorithm.class, SigningAlgorithm::toString);
    }
}

