/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.account.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.account.model.AccountRequest;
import software.amazon.awssdk.services.account.model.ContactInformation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutContactInformationRequest
extends AccountRequest
implements ToCopyableBuilder<Builder, PutContactInformationRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(PutContactInformationRequest.getter(PutContactInformationRequest::accountId)).setter(PutContactInformationRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<ContactInformation> CONTACT_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContactInformation").getter(PutContactInformationRequest.getter(PutContactInformationRequest::contactInformation)).setter(PutContactInformationRequest.setter(Builder::contactInformation)).constructor(ContactInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactInformation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, CONTACT_INFORMATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccountId", ACCOUNT_ID_FIELD);
            this.put("ContactInformation", CONTACT_INFORMATION_FIELD);
        }
    });
    private final String accountId;
    private final ContactInformation contactInformation;

    private PutContactInformationRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.contactInformation = builder.contactInformation;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final ContactInformation contactInformation() {
        return this.contactInformation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactInformation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutContactInformationRequest)) {
            return false;
        }
        PutContactInformationRequest other = (PutContactInformationRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.contactInformation(), other.contactInformation());
    }

    public final String toString() {
        return ToString.builder((String)"PutContactInformationRequest").add("AccountId", (Object)this.accountId()).add("ContactInformation", (Object)this.contactInformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ContactInformation": {
                return Optional.ofNullable(clazz.cast(this.contactInformation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutContactInformationRequest, T> g) {
        return obj -> g.apply((PutContactInformationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccountRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private ContactInformation contactInformation;

        private BuilderImpl() {
        }

        private BuilderImpl(PutContactInformationRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.contactInformation(model.contactInformation);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final ContactInformation.Builder getContactInformation() {
            return this.contactInformation != null ? this.contactInformation.toBuilder() : null;
        }

        public final void setContactInformation(ContactInformation.BuilderImpl contactInformation) {
            this.contactInformation = contactInformation != null ? contactInformation.build() : null;
        }

        @Override
        public final Builder contactInformation(ContactInformation contactInformation) {
            this.contactInformation = contactInformation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutContactInformationRequest build() {
            return new PutContactInformationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AccountRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutContactInformationRequest> {
        public Builder accountId(String var1);

        public Builder contactInformation(ContactInformation var1);

        default public Builder contactInformation(Consumer<ContactInformation.Builder> contactInformation) {
            return this.contactInformation((ContactInformation)((ContactInformation.Builder)ContactInformation.builder().applyMutation(contactInformation)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

