/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.account.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.account.model.AccountRequest;
import software.amazon.awssdk.services.account.model.RegionOptStatus;
import software.amazon.awssdk.services.account.model.RegionOptStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRegionsRequest
extends AccountRequest
implements ToCopyableBuilder<Builder, ListRegionsRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ListRegionsRequest.getter(ListRegionsRequest::accountId)).setter(ListRegionsRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListRegionsRequest.getter(ListRegionsRequest::maxResults)).setter(ListRegionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRegionsRequest.getter(ListRegionsRequest::nextToken)).setter(ListRegionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<String>> REGION_OPT_STATUS_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegionOptStatusContains").getter(ListRegionsRequest.getter(ListRegionsRequest::regionOptStatusContainsAsStrings)).setter(ListRegionsRequest.setter(Builder::regionOptStatusContainsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionOptStatusContains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, REGION_OPT_STATUS_CONTAINS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccountId", ACCOUNT_ID_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("RegionOptStatusContains", REGION_OPT_STATUS_CONTAINS_FIELD);
        }
    });
    private final String accountId;
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> regionOptStatusContains;

    private ListRegionsRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.regionOptStatusContains = builder.regionOptStatusContains;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final List<RegionOptStatus> regionOptStatusContains() {
        return RegionOptStatusListCopier.copyStringToEnum(this.regionOptStatusContains);
    }

    public final boolean hasRegionOptStatusContains() {
        return this.regionOptStatusContains != null && !(this.regionOptStatusContains instanceof SdkAutoConstructList);
    }

    public final List<String> regionOptStatusContainsAsStrings() {
        return this.regionOptStatusContains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionOptStatusContains() ? this.regionOptStatusContainsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegionsRequest)) {
            return false;
        }
        ListRegionsRequest other = (ListRegionsRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasRegionOptStatusContains() == other.hasRegionOptStatusContains() && Objects.equals(this.regionOptStatusContainsAsStrings(), other.regionOptStatusContainsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ListRegionsRequest").add("AccountId", (Object)this.accountId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("RegionOptStatusContains", this.hasRegionOptStatusContains() ? this.regionOptStatusContainsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RegionOptStatusContains": {
                return Optional.ofNullable(clazz.cast(this.regionOptStatusContainsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRegionsRequest, T> g) {
        return obj -> g.apply((ListRegionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccountRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private Integer maxResults;
        private String nextToken;
        private List<String> regionOptStatusContains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegionsRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.regionOptStatusContainsWithStrings(model.regionOptStatusContains);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getRegionOptStatusContains() {
            if (this.regionOptStatusContains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regionOptStatusContains;
        }

        public final void setRegionOptStatusContains(Collection<String> regionOptStatusContains) {
            this.regionOptStatusContains = RegionOptStatusListCopier.copy(regionOptStatusContains);
        }

        @Override
        public final Builder regionOptStatusContainsWithStrings(Collection<String> regionOptStatusContains) {
            this.regionOptStatusContains = RegionOptStatusListCopier.copy(regionOptStatusContains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionOptStatusContainsWithStrings(String ... regionOptStatusContains) {
            this.regionOptStatusContainsWithStrings(Arrays.asList(regionOptStatusContains));
            return this;
        }

        @Override
        public final Builder regionOptStatusContains(Collection<RegionOptStatus> regionOptStatusContains) {
            this.regionOptStatusContains = RegionOptStatusListCopier.copyEnumToString(regionOptStatusContains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionOptStatusContains(RegionOptStatus ... regionOptStatusContains) {
            this.regionOptStatusContains(Arrays.asList(regionOptStatusContains));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRegionsRequest build() {
            return new ListRegionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AccountRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRegionsRequest> {
        public Builder accountId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder regionOptStatusContainsWithStrings(Collection<String> var1);

        public Builder regionOptStatusContainsWithStrings(String ... var1);

        public Builder regionOptStatusContains(Collection<RegionOptStatus> var1);

        public Builder regionOptStatusContains(RegionOptStatus ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

