/*
 * Decompiled with CFR 0.152.
 */
package sh.tak.appbundler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.velocity.VelocityComponent;
import sh.tak.appbundler.FileSet;
import sh.tak.appbundler.logging.MojoLogChute;

public class CreateApplicationBundleMojo
extends AbstractMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final String TARGET_CLASS_ROOT = "target" + File.separator + "classes";
    private static String[] defaultJvmOptions = new String[]{"-Dapple.laf.useScreenMenuBar=true"};
    private boolean embeddJre = false;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private VelocityComponent velocity;
    private List<String> additionalClasspath;
    private List<FileSet> additionalResources;
    private List<FileSet> additionalBundledClasspathResources;
    private File buildDirectory;
    private String bundleName;
    private String dictionaryFile;
    private File diskImageFile;
    private boolean diskImageInternetEnable;
    private boolean generateDiskImageFile;
    private boolean includeApplicationsSymlink;
    private String iconFile;
    private String javaLauncherName;
    private List<String> jvmOptions;
    private String jvmVersion;
    private String mainClass;
    private String version;
    private String workingDirectory;
    private String jrePath;
    private String jreFullPath;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Creating and setting up the bundle directories");
        this.buildDirectory.mkdirs();
        File bundleDir = new File(this.buildDirectory, this.bundleName + ".app");
        bundleDir.mkdirs();
        File contentsDir = new File(bundleDir, "Contents");
        contentsDir.mkdirs();
        File resourcesDir = new File(contentsDir, "Resources");
        resourcesDir.mkdirs();
        File javaDirectory = new File(contentsDir, "Java");
        javaDirectory.mkdirs();
        File macOSDirectory = new File(contentsDir, "MacOS");
        macOSDirectory.mkdirs();
        this.getLog().info((CharSequence)"Copying the native Java Application Stub");
        File launcher = new File(macOSDirectory, this.javaLauncherName);
        launcher.setExecutable(true);
        FileOutputStream launcherStream = null;
        try {
            launcherStream = new FileOutputStream(launcher);
        }
        catch (FileNotFoundException ex) {
            throw new MojoExecutionException("Could not copy file to directory " + launcher, (Exception)ex);
        }
        InputStream launcherResourceStream = ((Object)((Object)this)).getClass().getResourceAsStream(this.javaLauncherName);
        try {
            IOUtil.copy((InputStream)launcherResourceStream, (OutputStream)launcherStream);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Could not copy file " + this.javaLauncherName + " to directory " + macOSDirectory, (Exception)ex);
        }
        if (this.iconFile != null) {
            File f = CreateApplicationBundleMojo.searchFile(this.iconFile, this.project.getBasedir());
            if (f != null && f.exists() && f.isFile()) {
                this.getLog().info((CharSequence)"Copying the Icon File");
                try {
                    FileUtils.copyFileToDirectory((File)f, (File)resourcesDir);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Error copying file " + this.iconFile + " to " + resourcesDir, (Exception)ex);
                }
            } else {
                throw new MojoExecutionException(String.format("Could not locate iconFile '%s'", this.iconFile));
            }
        }
        this.getLog().info((CharSequence)"Copying dependencies");
        List<String> files = this.copyDependencies(javaDirectory);
        if (this.additionalBundledClasspathResources != null && !this.additionalBundledClasspathResources.isEmpty()) {
            files.addAll(this.copyAdditionalBundledClasspathResources(javaDirectory, "lib", this.additionalBundledClasspathResources));
        }
        if (this.jrePath != null) {
            File f = new File(this.jrePath);
            if (f.exists() && f.isDirectory()) {
                File pluginsDirectory = new File(contentsDir, "PlugIns/JRE/Contents/Home/jre");
                pluginsDirectory.mkdirs();
                File sourceFolder = new File(this.jrePath, "Contents/Home");
                if (new File(this.jrePath, "Contents/Home/jre").exists()) {
                    sourceFolder = new File(this.jrePath, "Contents/Home/jre");
                }
                try {
                    this.getLog().info((CharSequence)("Copying the JRE Folder from : [" + sourceFolder + "] to PlugIn folder: [" + pluginsDirectory + "]"));
                    FileUtils.copyDirectoryStructure((File)sourceFolder, (File)pluginsDirectory);
                    File binFolder = new File(pluginsDirectory, "bin");
                    for (String filename : binFolder.list()) {
                        new File(binFolder, filename).setExecutable(true, false);
                    }
                    new File(pluginsDirectory, "lib/jspawnhelper").setExecutable(true, false);
                    this.embeddJre = true;
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Error copying folder " + f + " to " + pluginsDirectory, (Exception)ex);
                }
            } else {
                this.getLog().warn((CharSequence)"JRE not found check jrePath setting in pom.xml");
            }
        } else if (this.jreFullPath != null) {
            this.getLog().info((CharSequence)("JRE Full path is used [" + this.jreFullPath + "]"));
            this.embeddJre = true;
        }
        this.getLog().info((CharSequence)"Writing the Info.plist file");
        File infoPlist = new File(bundleDir, "Contents" + File.separator + "Info.plist");
        this.writeInfoPlist(infoPlist, files);
        this.getLog().info((CharSequence)"Copying additional resources");
        if (this.additionalResources != null && !this.additionalResources.isEmpty()) {
            this.copyResources(this.buildDirectory, this.additionalResources);
        }
        if (!SystemUtils.IS_OS_WINDOWS) {
            this.getLog().info((CharSequence)"Making stub executable");
            Commandline chmod = new Commandline();
            try {
                chmod.setExecutable("chmod");
                chmod.createArgument().setValue("755");
                chmod.createArgument().setValue(launcher.getAbsolutePath());
                chmod.execute();
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException("Error executing " + chmod + " ", (Exception)((Object)e));
            }
        } else {
            this.getLog().warn((CharSequence)"The stub was created without executable file permissions for UNIX systems");
        }
        if (this.generateDiskImageFile) {
            if (SystemUtils.IS_OS_MAC_OSX) {
                this.getLog().info((CharSequence)"Generating the Disk Image file");
                Commandline dmg = new Commandline();
                try {
                    if (this.includeApplicationsSymlink) {
                        this.createApplicationsSymlink();
                    }
                    dmg.setExecutable("hdiutil");
                    dmg.createArgument().setValue("create");
                    dmg.createArgument().setValue("-srcfolder");
                    dmg.createArgument().setValue(this.buildDirectory.getAbsolutePath());
                    dmg.createArgument().setValue(this.diskImageFile.getAbsolutePath());
                    try {
                        dmg.execute().waitFor();
                    }
                    catch (InterruptedException ex) {
                        throw new MojoExecutionException("Thread was interrupted while creating DMG " + this.diskImageFile, (Exception)ex);
                    }
                    finally {
                        if (this.includeApplicationsSymlink) {
                            this.removeApplicationsSymlink();
                        }
                    }
                }
                catch (CommandLineException ex) {
                    throw new MojoExecutionException("Error creating disk image " + this.diskImageFile, (Exception)((Object)ex));
                }
                if (this.diskImageInternetEnable) {
                    this.getLog().info((CharSequence)"Enabling the Disk Image file for internet");
                    try {
                        Commandline internetEnableCommand = new Commandline();
                        internetEnableCommand.setExecutable("hdiutil");
                        internetEnableCommand.createArgument().setValue("internet-enable");
                        internetEnableCommand.createArgument().setValue("-yes");
                        internetEnableCommand.createArgument().setValue(this.diskImageFile.getAbsolutePath());
                        internetEnableCommand.execute();
                    }
                    catch (CommandLineException ex) {
                        throw new MojoExecutionException("Error internet enabling disk image: " + this.diskImageFile, (Exception)((Object)ex));
                    }
                }
                this.projectHelper.attachArtifact(this.project, "dmg", null, this.diskImageFile);
            }
            if (SystemUtils.IS_OS_LINUX) {
                this.getLog().info((CharSequence)"Generating the Disk Image file");
                Commandline linux_dmg = new Commandline();
                try {
                    linux_dmg.setExecutable("genisoimage");
                    linux_dmg.createArgument().setValue("-V");
                    linux_dmg.createArgument().setValue(this.bundleName);
                    linux_dmg.createArgument().setValue("-D");
                    linux_dmg.createArgument().setValue("-R");
                    linux_dmg.createArgument().setValue("-apple");
                    linux_dmg.createArgument().setValue("-no-pad");
                    linux_dmg.createArgument().setValue("-o");
                    linux_dmg.createArgument().setValue(this.diskImageFile.getAbsolutePath());
                    linux_dmg.createArgument().setValue(this.buildDirectory.getAbsolutePath());
                    try {
                        linux_dmg.execute().waitFor();
                    }
                    catch (InterruptedException ex) {
                        throw new MojoExecutionException("Thread was interrupted while creating DMG " + this.diskImageFile, (Exception)ex);
                    }
                }
                catch (CommandLineException ex) {
                    throw new MojoExecutionException("Error creating disk image " + this.diskImageFile + " genisoimage probably missing", (Exception)((Object)ex));
                }
                this.projectHelper.attachArtifact(this.project, "dmg", null, this.diskImageFile);
            } else {
                this.getLog().warn((CharSequence)"Disk Image file cannot be generated in non Mac OS X and Linux environments");
            }
        }
        this.getLog().info((CharSequence)"App Bundle generation finished");
    }

    private String cleanBundleName(String bundleName) {
        return bundleName.replace(':', '-');
    }

    private List<String> copyDependencies(File javaDirectory) throws MojoExecutionException {
        DefaultRepositoryLayout layout = new DefaultRepositoryLayout();
        ArrayList<String> list = new ArrayList<String>();
        File artifactFile = this.project.getArtifact().getFile();
        list.add(layout.pathOf(this.project.getArtifact()));
        try {
            FileUtils.copyFile((File)artifactFile, (File)new File(javaDirectory, layout.pathOf(this.project.getArtifact())));
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Could not copy artifact file " + artifactFile + " to " + javaDirectory, (Exception)ex);
        }
        for (Artifact artifact : this.project.getArtifacts()) {
            File file = artifact.getFile();
            File dest = new File(javaDirectory, layout.pathOf(artifact));
            this.getLog().debug((CharSequence)("Adding " + file));
            try {
                FileUtils.copyFile((File)file, (File)dest);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Error copying file " + file + " into " + javaDirectory, (Exception)ex);
            }
            list.add(layout.pathOf(artifact));
        }
        return list;
    }

    private List<String> copyAdditionalBundledClasspathResources(File javaDirectory, String targetDirectoryName, List<FileSet> additionalBundledClasspathResources) throws MojoExecutionException {
        File destinationDirectory = new File(javaDirectory, targetDirectoryName);
        destinationDirectory.mkdirs();
        List<String> addedFilenames = this.copyResources(destinationDirectory, additionalBundledClasspathResources);
        return this.addPath(addedFilenames, targetDirectoryName);
    }

    private List<String> addPath(List<String> filenames, String additionalPath) {
        ArrayList<String> newFilenames = new ArrayList<String>(filenames.size());
        for (String filename : filenames) {
            newFilenames.add(additionalPath + '/' + filename);
        }
        return newFilenames;
    }

    private void writeInfoPlist(File infoPlist, List<String> files) throws MojoExecutionException {
        Velocity.setProperty((String)"runtime.log.logsystem", (Object)new MojoLogChute((Mojo)this));
        Velocity.setProperty((String)"file.resource.loader.path", (Object)TARGET_CLASS_ROOT);
        try {
            Velocity.init();
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Exception occured in initializing velocity", ex);
        }
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("mainClass", (Object)this.mainClass);
        velocityContext.put("cfBundleExecutable", (Object)this.javaLauncherName);
        velocityContext.put("bundleName", (Object)this.cleanBundleName(this.bundleName));
        velocityContext.put("workingDirectory", (Object)this.workingDirectory);
        if (this.embeddJre && this.jrePath != null) {
            velocityContext.put("jrePath", (Object)"JRE");
            velocityContext.put("jreFullPath", (Object)"");
        } else if (this.embeddJre && this.jreFullPath != null) {
            velocityContext.put("jrePath", (Object)"");
            velocityContext.put("jreFullPath", (Object)this.jreFullPath);
        } else {
            velocityContext.put("jrePath", (Object)"");
            velocityContext.put("jreFullPath", (Object)"");
        }
        if (this.iconFile == null) {
            velocityContext.put("iconFile", (Object)"GenericJavaApp.icns");
        } else {
            File f = CreateApplicationBundleMojo.searchFile(this.iconFile, this.project.getBasedir());
            velocityContext.put("iconFile", (Object)(f != null && f.exists() && f.isFile() ? f.getName() : "GenericJavaApp.icns"));
        }
        velocityContext.put("version", (Object)this.version);
        velocityContext.put("jvmVersion", (Object)this.jvmVersion);
        StringBuilder options = new StringBuilder();
        options.append("<array>").append("\n      ");
        for (String jvmOption : defaultJvmOptions) {
            options.append("      ").append("<string>").append(jvmOption).append("</string>").append("\n");
        }
        options.append("      ").append("<string>").append("-Xdock:name=" + this.bundleName).append("</string>").append("\n");
        if (this.jvmOptions != null) {
            for (String jvmOption : this.jvmOptions) {
                options.append("      ").append("<string>").append(jvmOption).append("</string>").append("\n");
            }
        }
        options.append("    ").append("</array>");
        velocityContext.put("jvmOptions", (Object)options);
        StringBuilder jarFiles = new StringBuilder();
        jarFiles.append("<array>").append("\n");
        for (String file : files) {
            jarFiles.append("      ").append("<string>").append(file).append("</string>").append("\n");
        }
        if (this.additionalClasspath != null) {
            for (String pathElement : this.additionalClasspath) {
                jarFiles.append("      ").append("<string>").append(pathElement).append("</string>");
            }
        }
        jarFiles.append("    ").append("</array>");
        velocityContext.put("classpath", (Object)jarFiles.toString());
        try {
            File sourceInfoPlist = new File(TARGET_CLASS_ROOT, this.dictionaryFile);
            if (sourceInfoPlist.exists() && sourceInfoPlist.isFile()) {
                String encoding = CreateApplicationBundleMojo.detectEncoding(sourceInfoPlist);
                this.getLog().debug((CharSequence)("Detected encoding " + encoding + " for dictionary file " + this.dictionaryFile));
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(infoPlist), encoding);
                Template template = Velocity.getTemplate((String)this.dictionaryFile, (String)encoding);
                template.merge((Context)velocityContext, (Writer)writer);
                ((Writer)writer).close();
            } else {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(infoPlist), "UTF-8");
                this.velocity.getEngine().mergeTemplate(this.dictionaryFile, "UTF-8", (Context)velocityContext, (Writer)writer);
                ((Writer)writer).close();
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Could not write Info.plist to file " + infoPlist, (Exception)ex);
        }
        catch (ParseErrorException ex) {
            throw new MojoExecutionException("Error parsing " + this.dictionaryFile, (Exception)((Object)ex));
        }
        catch (ResourceNotFoundException ex) {
            throw new MojoExecutionException("Could not find resource for template " + this.dictionaryFile, (Exception)((Object)ex));
        }
        catch (MethodInvocationException ex) {
            throw new MojoExecutionException("MethodInvocationException occured merging Info.plist template " + this.dictionaryFile, (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Exception occured merging Info.plist template " + this.dictionaryFile, ex);
        }
    }

    private static String detectEncoding(File file) throws Exception {
        return XMLInputFactory.newInstance().createXMLStreamReader(new FileReader(file)).getCharacterEncodingScheme();
    }

    private List<String> scanFileSet(File sourceDirectory, FileSet fileSet) {
        String[] emptyStringArray = new String[]{};
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDirectory);
        if (fileSet.getIncludes() != null && !fileSet.getIncludes().isEmpty()) {
            scanner.setIncludes(fileSet.getIncludes().toArray(emptyStringArray));
        } else {
            scanner.setIncludes(DEFAULT_INCLUDES);
        }
        if (fileSet.getExcludes() != null && !fileSet.getExcludes().isEmpty()) {
            scanner.setExcludes(fileSet.getExcludes().toArray(emptyStringArray));
        }
        if (fileSet.isUseDefaultExcludes()) {
            scanner.addDefaultExcludes();
        }
        scanner.scan();
        return Arrays.asList(scanner.getIncludedFiles());
    }

    private List<String> copyResources(File targetDirectory, List<FileSet> fileSets) throws MojoExecutionException {
        ArrayList<String> addedFiles = new ArrayList<String>();
        for (FileSet fileSet : fileSets) {
            File sourceDirectory = new File(fileSet.getDirectory());
            if (!sourceDirectory.isAbsolute()) {
                sourceDirectory = new File(this.project.getBasedir(), sourceDirectory.getPath());
            }
            if (!sourceDirectory.exists()) {
                this.getLog().warn((CharSequence)("Specified source directory " + sourceDirectory.getPath() + " does not exist."));
                continue;
            }
            List<String> includedFiles = this.scanFileSet(sourceDirectory, fileSet);
            addedFiles.addAll(includedFiles);
            this.getLog().info((CharSequence)("Copying " + includedFiles.size() + " additional resource" + (includedFiles.size() > 1 ? "s" : "")));
            for (String destination : includedFiles) {
                File source = new File(sourceDirectory, destination);
                File destinationFile = new File(targetDirectory, destination);
                destinationFile.getParentFile().mkdirs();
                try {
                    FileUtils.copyFile((File)source, (File)destinationFile);
                    destinationFile.setExecutable(fileSet.isExecutable(), false);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error copying additional resource " + source, (Exception)e);
                }
            }
        }
        return addedFiles;
    }

    private static File searchFile(String path, File basedir) {
        File f = new File(basedir, path);
        if (f.exists()) {
            return f;
        }
        f = new File(TARGET_CLASS_ROOT, path);
        if (f.exists()) {
            return f;
        }
        return null;
    }

    private void createApplicationsSymlink() throws MojoExecutionException, CommandLineException {
        Commandline symlink = new Commandline();
        symlink.setExecutable("ln");
        symlink.createArgument().setValue("-s");
        symlink.createArgument().setValue("/Applications");
        symlink.createArgument().setValue(this.buildDirectory.getAbsolutePath());
        try {
            symlink.execute().waitFor();
        }
        catch (InterruptedException ex) {
            throw new MojoExecutionException("Error preparing bundle disk image while creating symlink" + this.diskImageFile, (Exception)ex);
        }
    }

    private void removeApplicationsSymlink() throws MojoExecutionException, CommandLineException {
        Commandline remSymlink = new Commandline();
        String symlink = this.buildDirectory.getAbsolutePath() + "/Applications";
        if (!new File(symlink).exists()) {
            return;
        }
        remSymlink.setExecutable("rm");
        remSymlink.createArgument().setValue(symlink);
        try {
            remSymlink.execute().waitFor();
        }
        catch (InterruptedException ex) {
            throw new MojoExecutionException("Error cleaning up (while removing " + symlink + " symlink.) Please check permissions for that symlink" + this.diskImageFile, (Exception)ex);
        }
    }
}

