/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.core.thread;

import com.xxl.job.admin.core.conf.XxlJobAdminConfig;
import com.xxl.job.admin.core.trigger.TriggerTypeEnum;
import com.xxl.job.admin.core.trigger.XxlJobTrigger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobTriggerPoolHelper {
    private static Logger logger = LoggerFactory.getLogger(JobTriggerPoolHelper.class);
    private ThreadPoolExecutor fastTriggerPool = null;
    private ThreadPoolExecutor slowTriggerPool = null;
    private volatile long minTim = System.currentTimeMillis() / 60000L;
    private volatile ConcurrentMap<Integer, AtomicInteger> jobTimeoutCountMap = new ConcurrentHashMap<Integer, AtomicInteger>();
    private static JobTriggerPoolHelper helper = new JobTriggerPoolHelper();

    public void start() {
        this.fastTriggerPool = new ThreadPoolExecutor(10, XxlJobAdminConfig.getAdminConfig().getTriggerPoolFastMax(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "xxl-job, admin JobTriggerPoolHelper-fastTriggerPool-" + r.hashCode());
            }
        });
        this.slowTriggerPool = new ThreadPoolExecutor(10, XxlJobAdminConfig.getAdminConfig().getTriggerPoolSlowMax(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(2000), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "xxl-job, admin JobTriggerPoolHelper-slowTriggerPool-" + r.hashCode());
            }
        });
    }

    public void stop() {
        this.fastTriggerPool.shutdownNow();
        this.slowTriggerPool.shutdownNow();
        logger.info(">>>>>>>>> xxl-job trigger thread pool shutdown success.");
    }

    public void addTrigger(final int jobId, final TriggerTypeEnum triggerType, final int failRetryCount, final String executorShardingParam, final String executorParam, final String addressList) {
        ThreadPoolExecutor triggerPool_ = this.fastTriggerPool;
        AtomicInteger jobTimeoutCount = (AtomicInteger)this.jobTimeoutCountMap.get(jobId);
        if (jobTimeoutCount != null && jobTimeoutCount.get() > 10) {
            triggerPool_ = this.slowTriggerPool;
        }
        triggerPool_.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    XxlJobTrigger.trigger(jobId, triggerType, failRetryCount, executorShardingParam, executorParam, addressList);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    AtomicInteger timeoutCount;
                    long cost;
                    long minTim_now = System.currentTimeMillis() / 60000L;
                    if (JobTriggerPoolHelper.this.minTim != minTim_now) {
                        JobTriggerPoolHelper.this.minTim = minTim_now;
                        JobTriggerPoolHelper.this.jobTimeoutCountMap.clear();
                    }
                    if ((cost = System.currentTimeMillis() - start) > 500L && (timeoutCount = JobTriggerPoolHelper.this.jobTimeoutCountMap.putIfAbsent(jobId, new AtomicInteger(1))) != null) {
                        timeoutCount.incrementAndGet();
                    }
                }
            }
        });
    }

    public static void toStart() {
        helper.start();
    }

    public static void toStop() {
        helper.stop();
    }

    public static void trigger(int jobId, TriggerTypeEnum triggerType, int failRetryCount, String executorShardingParam, String executorParam, String addressList) {
        helper.addTrigger(jobId, triggerType, failRetryCount, executorShardingParam, executorParam, addressList);
    }
}

