/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.core.thread;

import com.xxl.job.admin.core.conf.XxlJobAdminConfig;
import com.xxl.job.admin.core.model.XxlJobInfo;
import com.xxl.job.admin.core.model.XxlJobLog;
import com.xxl.job.admin.core.thread.JobTriggerPoolHelper;
import com.xxl.job.admin.core.trigger.TriggerTypeEnum;
import com.xxl.job.admin.core.util.I18nUtil;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobFailMonitorHelper {
    private static Logger logger = LoggerFactory.getLogger(JobFailMonitorHelper.class);
    private static JobFailMonitorHelper instance = new JobFailMonitorHelper();
    private Thread monitorThread;
    private volatile boolean toStop = false;

    public static JobFailMonitorHelper getInstance() {
        return instance;
    }

    public void start() {
        this.monitorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!JobFailMonitorHelper.this.toStop) {
                    block8: {
                        try {
                            List<Long> failLogIds = XxlJobAdminConfig.getAdminConfig().getXxlJobLogDao().findFailJobLogIds(1000);
                            if (failLogIds != null && !failLogIds.isEmpty()) {
                                for (long failLogId : failLogIds) {
                                    boolean alarmResult;
                                    int lockRet = XxlJobAdminConfig.getAdminConfig().getXxlJobLogDao().updateAlarmStatus(failLogId, 0, -1);
                                    if (lockRet < 1) continue;
                                    XxlJobLog log = XxlJobAdminConfig.getAdminConfig().getXxlJobLogDao().load(failLogId);
                                    XxlJobInfo info = XxlJobAdminConfig.getAdminConfig().getXxlJobInfoDao().loadById(log.getJobId());
                                    if (log.getExecutorFailRetryCount() > 0) {
                                        JobTriggerPoolHelper.trigger(log.getJobId(), TriggerTypeEnum.RETRY, log.getExecutorFailRetryCount() - 1, log.getExecutorShardingParam(), log.getExecutorParam(), null);
                                        String retryMsg = "<br><br><span style=\"color:#F39C12;\" > >>>>>>>>>>>" + I18nUtil.getString("jobconf_trigger_type_retry") + "<<<<<<<<<<< </span><br>";
                                        log.setTriggerMsg(log.getTriggerMsg() + retryMsg);
                                        XxlJobAdminConfig.getAdminConfig().getXxlJobLogDao().updateTriggerInfo(log);
                                    }
                                    int newAlarmStatus = 0;
                                    newAlarmStatus = info != null ? ((alarmResult = XxlJobAdminConfig.getAdminConfig().getJobAlarmer().alarm(info, log)) ? 2 : 3) : 1;
                                    XxlJobAdminConfig.getAdminConfig().getXxlJobLogDao().updateAlarmStatus(failLogId, -1, newAlarmStatus);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (JobFailMonitorHelper.this.toStop) break block8;
                            logger.error(">>>>>>>>>>> xxl-job, job fail monitor thread error:{}", (Throwable)e);
                        }
                    }
                    try {
                        TimeUnit.SECONDS.sleep(10L);
                    }
                    catch (Exception e) {
                        if (JobFailMonitorHelper.this.toStop) continue;
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                logger.info(">>>>>>>>>>> xxl-job, job fail monitor thread stop");
            }
        });
        this.monitorThread.setDaemon(true);
        this.monitorThread.setName("xxl-job, admin JobFailMonitorHelper");
        this.monitorThread.start();
    }

    public void toStop() {
        this.toStop = true;
        this.monitorThread.interrupt();
        try {
            this.monitorThread.join();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

