/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.core.route.strategy;

import com.xxl.job.admin.core.route.ExecutorRouter;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.biz.model.TriggerParam;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorRouteRound
extends ExecutorRouter {
    private static ConcurrentMap<Integer, AtomicInteger> routeCountEachJob = new ConcurrentHashMap<Integer, AtomicInteger>();
    private static long CACHE_VALID_TIME = 0L;

    private static int count(int jobId) {
        AtomicInteger count;
        if (System.currentTimeMillis() > CACHE_VALID_TIME) {
            routeCountEachJob.clear();
            CACHE_VALID_TIME = System.currentTimeMillis() + 86400000L;
        }
        if ((count = (AtomicInteger)routeCountEachJob.get(jobId)) == null || count.get() > 1000000) {
            count = new AtomicInteger(new Random().nextInt(100));
        } else {
            count.addAndGet(1);
        }
        routeCountEachJob.put(jobId, count);
        return count.get();
    }

    @Override
    public ReturnT<String> route(TriggerParam triggerParam, List<String> addressList) {
        String address = addressList.get(ExecutorRouteRound.count(triggerParam.getJobId()) % addressList.size());
        return new ReturnT((Object)address);
    }
}

