package org.violet.common.security.util;

import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.stp.StpUtil;
import lombok.extern.slf4j.Slf4j;
import org.violet.common.core.entity.LoginUser;
import org.violet.common.security.entity.AppLoginUser;

/**
 * 安全工具类
 */
@Slf4j
public class SecurityUtil {

    public SecurityUtil() {
    }

    public static void setLoginUser(LoginUser loginUser) {
        StpUtil.getTokenSession().set("LOGIN_USER", loginUser);
    }

    public static LoginUser getLoginUser() {
        try {
            Object o = StpUtil.getTokenSession().get("LOGIN_USER");
            if (o != null) {
                return (LoginUser) o;
            }
        } catch (Exception var1) {
            log.error("获取当前登陆人出错", var1);
        }

        return null;
    }

    public static Long getLoginUserId() {
        try {
            Object o = StpUtil.getTokenSession().get("LOGIN_USER");
            if (o != null) {
                LoginUser loginUser = (LoginUser) o;
                return loginUser.getUserId();
            }
        } catch (Exception var2) {
            log.error("获取当前登陆人出错", var2);
        }

        return null;
    }

    public static String getLoginUserIdStr() {
        try {
            Object o = StpUtil.getTokenSession().get("LOGIN_USER");
            if (o != null) {
                LoginUser loginUser = (LoginUser) o;
                return loginUser.getUserId().toString();
            }
        } catch (Exception var2) {
            log.error("获取当前登陆人出错", var2);
        }

        return null;
    }

    public static Long getLoginUserOrgId() {
        LoginUser user = getLoginUser();
        return user != null ? user.getOrgId() : null;
    }

    public static Long getLoginUserDeptId() {
        LoginUser user = getLoginUser();
        return user != null ? user.getDeptId() : null;
    }

    public static void setChargeLoginUser(AppLoginUser loginUser) {
        StpUserUtil.getTokenSession().set("LOGIN_USER", loginUser);
    }

    public static Long getChargeLoginUserId() {
        try {
            Object o = StpUserUtil.getTokenSession().get("LOGIN_USER");
            if (o != null) {
                AppLoginUser loginUser = (AppLoginUser) o;
                return loginUser.getGroupUserId();
            }
        } catch (Exception var2) {
            log.error("获取当前登陆人出错", var2);
        }

        return null;
    }

    public static AppLoginUser getChargeLoginUser() {
        try {
            Object o = StpUserUtil.getTokenSession().get("LOGIN_USER");
            if (o != null) {
                AppLoginUser loginUser = (AppLoginUser) o;
                return loginUser;
            }
        } catch (Exception var2) {
            log.error("获取当前登陆人出错", var2);
        }

        return null;
    }
}
