package org.violet.common.mybatis.config;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * MybatisPlus扩展配置类
 */
@Data
@ConfigurationProperties(prefix = "violet.mybatis-plus")
public class MybatisPlusProperties {

    private Boolean isTentant = false;
    /**
     * 分页最大数
     */
    private Long pageLimit = 500L;

    /**
     * 溢出总页数后是否进行处理
     */
    protected Boolean overflow = false;

    /**
     * 是否debug
     */
    private Boolean debug = true;
    /**
     * 是否打印sql
     */
    private Boolean printSql = true;
    /**
     * 日志是否记录sql
     */
    private Boolean logSql = true;
    /**
     * 日志是否只记录慢sql
     */
    private Boolean logOnlySlowSql = true;
    /**
     * 慢查询sql的查询时间
     */
    private Long slowSqlMillis = 1000L;


}
