/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.mybatis.config;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusPropertiesCustomizer;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.util.List;
import lombok.Generated;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.violet.common.core.util.KindId;
import org.violet.common.core.util.ObjectUtil;
import org.violet.common.mybatis.config.MybatisPlusProperties;
import org.violet.common.mybatis.intercept.QueryInterceptor;
import org.violet.common.mybatis.plugin.PerformanceInterceptor;
import org.violet.common.mybatis.plugin.VioletPaginationInterceptor;
import org.violet.common.mybatis.support.PageRequestHandlerMethodArgumentResolver;

@AutoConfiguration
@MapperScan(value={"org.violet.**.mapper.**"})
@EnableConfigurationProperties(value={MybatisPlusProperties.class})
public class MybatisPlusConfiguration
implements WebMvcConfigurer {
    private MybatisPlusProperties mybatisPlusProperties;

    @Bean
    public MybatisPlusPropertiesCustomizer plusPropertiesCustomizer() {
        return plusProperties -> plusProperties.getGlobalConfig().setBanner(false);
    }

    @Bean
    public PerformanceInterceptor performanceInterceptor() {
        PerformanceInterceptor performanceInterceptor = new PerformanceInterceptor();
        performanceInterceptor.setLogSql(this.mybatisPlusProperties.getLogSql());
        performanceInterceptor.setPrintSql(this.mybatisPlusProperties.getDebug() != false && this.mybatisPlusProperties.getPrintSql() != false);
        performanceInterceptor.setSlowSqlMillis(this.mybatisPlusProperties.getSlowSqlMillis());
        performanceInterceptor.setLogOnlySlowSql(this.mybatisPlusProperties.getLogOnlySlowSql());
        return performanceInterceptor;
    }

    @Bean
    @ConditionalOnMissingBean(value={MybatisPlusInterceptor.class})
    public MybatisPlusInterceptor mybatisPlusInterceptor(ObjectProvider<QueryInterceptor[]> queryInterceptors, MybatisPlusProperties mybatisPlusProperties) {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        VioletPaginationInterceptor paginationInterceptor = new VioletPaginationInterceptor();
        Object[] queryInterceptorArray = (QueryInterceptor[])queryInterceptors.getIfAvailable();
        if (ObjectUtil.isNotEmpty((Object)queryInterceptorArray)) {
            AnnotationAwareOrderComparator.sort((Object[])queryInterceptorArray);
            paginationInterceptor.setQueryInterceptors((QueryInterceptor[])queryInterceptorArray);
        }
        paginationInterceptor.setMaxLimit(mybatisPlusProperties.getPageLimit());
        paginationInterceptor.setOverflow(mybatisPlusProperties.getOverflow());
        interceptor.addInnerInterceptor((InnerInterceptor)paginationInterceptor);
        return interceptor;
    }

    @Bean
    public IdentifierGenerator customIdGenerator() {
        return entity -> KindId.nextId();
    }

    @Bean
    public PageRequestHandlerMethodArgumentResolver pageHandlerMethodArgumentResolver() {
        return new PageRequestHandlerMethodArgumentResolver();
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(this.pageHandlerMethodArgumentResolver());
    }

    @Generated
    public MybatisPlusConfiguration(MybatisPlusProperties mybatisPlusProperties) {
        this.mybatisPlusProperties = mybatisPlusProperties;
    }
}

