package org.violet.common.mybatis.plugin;

import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.violet.common.core.util.ObjectUtil;
import org.violet.common.mybatis.intercept.QueryInterceptor;


/**
 * 查询拦截器执行器，用于执行自定义查询拦截器
 */
@SuppressWarnings({"rawtypes"})
public class QueryInterceptorExecutor {

    /**
     * 执行查询拦截器
     */
    static void exec(QueryInterceptor[] interceptors, Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws Throwable {
        if (ObjectUtil.isEmpty(interceptors)) {
            return;
        }
        for (QueryInterceptor interceptor : interceptors) {
            interceptor.intercept(executor, ms, parameter, rowBounds, resultHandler, boundSql);
        }
    }

}
