package org.violet.common.mybatis.config;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusPropertiesCustomizer;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import org.violet.common.launch.constant.AppConstant;
import lombok.AllArgsConstructor;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.violet.common.core.util.KindId;
import org.violet.common.core.util.ObjectUtil;
import org.violet.common.mybatis.intercept.QueryInterceptor;
import org.violet.common.mybatis.plugin.PerformanceInterceptor;
import org.violet.common.mybatis.plugin.VioletPaginationInterceptor;
import org.violet.common.mybatis.support.PageRequestHandlerMethodArgumentResolver;

import java.util.List;

/***
 * mybatisplus 配置
 * @author wjx
 * @date 2024/11/27 17:39
 */
@AutoConfiguration
@MapperScan(AppConstant.BASE_PACKAGES + ".**.mapper.**")
@EnableConfigurationProperties(MybatisPlusProperties.class)
@AllArgsConstructor
public class MybatisPlusConfiguration implements WebMvcConfigurer {

    private MybatisPlusProperties mybatisPlusProperties;

    /**
     * 租户拦截器
     */
//    @Bean
//    @ConditionalOnMissingBean(TenantLineInnerInterceptor.class)
//
//    public TenantLineInnerInterceptor tenantLineInnerInterceptor() {
//        return new TenantLineInnerInterceptor(new TenantLineHandler() {
//            @Override
//            public Expression getTenantId() {
//                return new StringValue(Func.toStr(SecureUtil.getTenantId(), AppConstant.ADMIN_TENANT_ID));
//            }
//
//            @Override
//            public boolean ignoreTable(String tableName) {
//                return true;
//            }
//        });
//    }

    //取消打印banner
    @Bean
    public MybatisPlusPropertiesCustomizer plusPropertiesCustomizer() {
        return (plusProperties) -> {
            plusProperties.getGlobalConfig().setBanner(false);
        };
    }

    /**
     * 性能插件
     *
     * @return
     */
    @Bean
    public PerformanceInterceptor performanceInterceptor() {
        PerformanceInterceptor performanceInterceptor = new PerformanceInterceptor();
        performanceInterceptor.setLogSql(mybatisPlusProperties.getLogSql());
        performanceInterceptor.setPrintSql(mybatisPlusProperties.getDebug() && mybatisPlusProperties.getPrintSql());
        performanceInterceptor.setSlowSqlMillis(mybatisPlusProperties.getSlowSqlMillis());
        performanceInterceptor.setLogOnlySlowSql(mybatisPlusProperties.getLogOnlySlowSql());
        return performanceInterceptor;
    }

    /**
     * 使用扩展版分页插件
     *
     * @return
     */
    @Bean
    @ConditionalOnMissingBean({MybatisPlusInterceptor.class})
    public MybatisPlusInterceptor mybatisPlusInterceptor(ObjectProvider<QueryInterceptor[]> queryInterceptors,
                                                         MybatisPlusProperties mybatisPlusProperties) {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        VioletPaginationInterceptor paginationInterceptor = new VioletPaginationInterceptor();
        // 配置自定义查询拦截器,方便后续进行扩展
        QueryInterceptor[] queryInterceptorArray = queryInterceptors.getIfAvailable();
        if (ObjectUtil.isNotEmpty(queryInterceptorArray)) {
            AnnotationAwareOrderComparator.sort(queryInterceptorArray);
            paginationInterceptor.setQueryInterceptors(queryInterceptorArray);
        }
        paginationInterceptor.setMaxLimit(mybatisPlusProperties.getPageLimit());
        paginationInterceptor.setOverflow(mybatisPlusProperties.getOverflow());
        interceptor.addInnerInterceptor(paginationInterceptor);
        return interceptor;
    }

    //配置id生成器
    @Bean
    public IdentifierGenerator customIdGenerator() {
        return entity -> KindId.nextId();
    }

    //添加参数解析器，用于自动解析分页参数
    @Bean
    public PageRequestHandlerMethodArgumentResolver pageHandlerMethodArgumentResolver() {
        return new PageRequestHandlerMethodArgumentResolver();
    }

    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(pageHandlerMethodArgumentResolver());
    }


}
