/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.datascope.interceptor;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.violet.common.core.embed.dict.CommonDataAuth;
import org.violet.common.core.entity.LoginUser;
import org.violet.common.core.enums.LoginUserType;
import org.violet.common.core.util.ClassUtil;
import org.violet.common.core.util.SpringUtil;
import org.violet.common.core.util.StringUtil;
import org.violet.common.datascope.annotations.DataScope;
import org.violet.common.datascope.config.DataScopeProperties;
import org.violet.common.datascope.handler.DataScopeHandler;
import org.violet.common.mybatis.intercept.QueryInterceptor;
import org.violet.common.security.util.SecurityUtil;

public class DataScopeInterceptor
implements QueryInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataScopeInterceptor.class);
    private final ConcurrentMap<String, DataScope> dataAuthMap = new ConcurrentHashMap<String, DataScope>(8);
    private final DataScopeHandler dataScopeHandler;
    private final DataScopeProperties dataScopeProperties;

    public void intercept(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        if (!this.dataScopeProperties.getEnabled().booleanValue()) {
            return;
        }
        LoginUser longinUser = SecurityUtil.getLoginUser();
        if (longinUser == null) {
            return;
        }
        if (SqlCommandType.SELECT != ms.getSqlCommandType() || StatementType.CALLABLE == ms.getStatementType()) {
            return;
        }
        String originalSql = boundSql.getSql();
        DataScope dataScope = this.findDataScopeAnnotation(ms);
        String mapperId = ms.getId();
        String className = mapperId.substring(0, mapperId.lastIndexOf("."));
        String mapperName = ClassUtil.getShortName((String)className);
        String methodName = mapperId.substring(mapperId.lastIndexOf(".") + 1);
        boolean mapperSkip = this.dataScopeProperties.getMapperExclude().stream().anyMatch(mapperName::contains);
        if (dataScope == null || mapperSkip) {
            return;
        }
        if (dataScope.dataAuth() == CommonDataAuth.ALL_DATA) {
            return;
        }
        if (longinUser.getLoginUserType() == LoginUserType.ROOT) {
            return;
        }
        String sqlCondition = this.dataScopeHandler.sqlCondition(mapperId, dataScope, longinUser, originalSql);
        if (!StringUtil.isBlank((CharSequence)sqlCondition)) {
            PluginUtils.MPBoundSql mpBoundSql = PluginUtils.mpBoundSql((BoundSql)boundSql);
            mpBoundSql.sql(sqlCondition);
        }
    }

    private DataScope findDataScopeAnnotation(MappedStatement ms) {
        String id = ms.getId();
        return this.dataAuthMap.computeIfAbsent(id, key -> {
            Class[] interfaces;
            String className = key.substring(0, key.lastIndexOf("."));
            String mapperBean = StringUtil.firstCharToLower((String)ClassUtil.getShortName((String)className));
            Object mapper = SpringUtil.getBean((String)mapperBean);
            String methodName = key.substring(key.lastIndexOf(".") + 1);
            for (Class mapperInterface : interfaces = ClassUtil.getAllInterfaces((Object)mapper)) {
                for (Method method : mapperInterface.getDeclaredMethods()) {
                    if (!methodName.equals(method.getName()) || !method.isAnnotationPresent(DataScope.class)) continue;
                    return method.getAnnotation(DataScope.class);
                }
            }
            return null;
        });
    }

    @Generated
    public DataScopeInterceptor(DataScopeHandler dataScopeHandler, DataScopeProperties dataScopeProperties) {
        this.dataScopeHandler = dataScopeHandler;
        this.dataScopeProperties = dataScopeProperties;
    }
}

