/*
 * Decompiled with CFR 0.152.
 */
package org.violet.commom.crypto.advice;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import org.violet.commom.crypto.annotation.encrypt.ApiEncrypt;
import org.violet.commom.crypto.bean.CryptoInfoBean;
import org.violet.commom.crypto.config.ApiCryptoProperties;
import org.violet.commom.crypto.exception.EncryptBodyFailException;
import org.violet.commom.crypto.util.ApiCryptoUtil;
import org.violet.common.core.util.ClassUtil;
import org.violet.common.core.util.JsonUtil;

@Order(value=1)
@AutoConfiguration
@ControllerAdvice
@ConditionalOnProperty(value={"violet.crypto.enabled"}, havingValue="true", matchIfMissing=true)
public class ApiEncryptResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiEncryptResponseBodyAdvice.class);
    private final ApiCryptoProperties properties;

    public boolean supports(MethodParameter returnType, @NonNull Class converterType) {
        return ClassUtil.isAnnotated((Method)returnType.getMethod(), ApiEncrypt.class);
    }

    @Nullable
    public Object beforeBodyWrite(Object body, @NonNull MethodParameter returnType, @NonNull MediaType selectedContentType, @NonNull Class selectedConverterType, @NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response) {
        if (body == null) {
            return null;
        }
        response.getHeaders().setContentType(MediaType.TEXT_PLAIN);
        CryptoInfoBean cryptoInfoBean = ApiCryptoUtil.getEncryptInfo(returnType);
        if (cryptoInfoBean != null) {
            byte[] bodyJsonBytes = JsonUtil.toJsonAsBytes((Object)body);
            try (OutputStream stream = response.getBody();){
                stream.write(ApiCryptoUtil.encryptData(this.properties, bodyJsonBytes, cryptoInfoBean).getBytes(StandardCharsets.UTF_8));
                stream.flush();
            }
            catch (IOException e) {
                log.error("beforeBodyWrite stream write error", (Throwable)e);
            }
            return null;
        }
        throw new EncryptBodyFailException();
    }

    @Generated
    public ApiEncryptResponseBodyAdvice(ApiCryptoProperties properties) {
        this.properties = properties;
    }
}

