package org.violet.commom.crypto.annotation.decrypt;


import org.springframework.core.annotation.AliasFor;
import org.violet.commom.crypto.enums.CryptoType;

import java.lang.annotation.*;

/**
 * des 解密
 *
 * @see ApiDecrypt
 */
@Target({ElementType.TYPE, ElementType.METHOD, ElementType.PARAMETER})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@ApiDecrypt(CryptoType.DES)
public @interface ApiDecryptDes {

	/**
	 * Alias for {@link ApiDecrypt#secretKey()}.
	 *
	 * @return {String}
	 */
	@AliasFor(annotation = ApiDecrypt.class)
	String secretKey() default "";

}
