/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.core.config.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.io.IOException;
import java.util.List;

public class VioletBeanSerializerModifier
extends BeanSerializerModifier {
    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        return super.changeProperties(config, beanDesc, beanProperties);
    }

    public static interface NullJsonSerializers {
        public static final JsonSerializer<Object> STRING_JSON_SERIALIZER = new JsonSerializer<Object>(){

            public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeString("");
            }
        };
        public static final JsonSerializer<Object> NUMBER_JSON_SERIALIZER = new JsonSerializer<Object>(){

            public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeNumber(-1);
            }
        };
        public static final JsonSerializer<Object> BOOLEAN_JSON_SERIALIZER = new JsonSerializer<Object>(){

            public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeObject((Object)Boolean.FALSE);
            }
        };
        public static final JsonSerializer<Object> ARRAY_JSON_SERIALIZER = new JsonSerializer<Object>(){

            public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeStartArray();
                gen.writeEndArray();
            }
        };
        public static final JsonSerializer<Object> OBJECT_JSON_SERIALIZER = new JsonSerializer<Object>(){

            public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeStartObject();
                gen.writeEndObject();
            }
        };
    }
}

