package org.violet.common.core.util;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;

import cn.hutool.extra.servlet.JakartaServletUtil;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentInfo;
import cn.hutool.http.useragent.UserAgentUtil;
import com.alibaba.fastjson2.JSON;

import org.violet.common.launch.entity.JsonResult;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;


import java.nio.charset.StandardCharsets;


@Slf4j
public class ServletUtils extends JakartaServletUtil {
    /**
     * 用户UA请求头
     */
    public static final String USER_AGENT_HEADER = "User-Agent";
    /**
     * Window10以后加上的请求头
     */
    public static final String SEC_CH_UA_PLATFORM_VERSION = "Sec-Ch-Ua-Platform-Version";

    /**
     * 获得请求User-Agent信息对象
     *
     * @return
     */
    public static UserAgent getUserAgent() {
        UserAgent userAgent = UserAgentUtil.parse(JakartaServletUtil.getHeader(getRequest(), USER_AGENT_HEADER, StandardCharsets.UTF_8));
        return userAgent;
    }

    public static String getClientOS() {
        String winPlatformVersion = JakartaServletUtil.getHeader(getRequest(), SEC_CH_UA_PLATFORM_VERSION, StandardCharsets.UTF_8);
        if (StrUtil.isNotBlank(winPlatformVersion)) {
            Integer version = Convert.toInt(StrUtil.splitToArray(StrUtil.removeAll(winPlatformVersion, '"'), StrUtil.DOT)[0]);
            if (version >= 13) {
                return "Windows 11.0";
            } else {
                return "Windows 10.0";
            }
        }

        UserAgent userAgent = getUserAgent();
        if (userAgent != null) {
            return userAgent.getPlatform().getName() + StrUtil.SPACE + userAgent.getOsVersion();
        } else {
            return UserAgentInfo.NameUnknown;
        }
    }

    public static String getClientBrowser() {
        UserAgent userAgent = getUserAgent();
        if (userAgent != null) {
            return userAgent.getBrowser().getName() + "(" + userAgent.getEngine().getName() + ")";
        } else {
            return UserAgentInfo.NameUnknown;
        }
    }

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
    }

    /**
     * 获取 HttpServletRequest
     */
    public static HttpServletResponse getResponse() {
        HttpServletResponse response = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getResponse();
        return response;
    }


    /**
     * 获得用户请求IP
     *
     * @return
     */
    public static String getClientIp() {
        return JakartaServletUtil.getClientIP(getRequest());
    }

    /**
     * 返回json content-type为application/json
     *
     * @param response 渲染对象
     * @param json     待渲染的字符串
     */
    public static void renderJson(HttpServletResponse response, JsonResult json) {
        response.setCharacterEncoding("utf-8");
        JakartaServletUtil.write(response, JSON.toJSONString(json), "application/json");
    }

}
