package org.violet.common.core.util;

import cn.hutool.core.date.SystemClock;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.IdUtil;
import lombok.extern.slf4j.Slf4j;

import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Slf4j
public class KindId {

    private static final long OFFSET = 1577808000L;
    private static final long WORKER_ID;
    private static final long WORKER_ID_BITS = 5L;
    private static final long SEQUENCE_ID_BITS = 16L;
    private static final long WORKER_SHIFT_BITS = 16L;
    private static final long OFFSET_SHIFT_BITS = 21L;
    private static final long WORKER_ID_MAX = 15L;
    private static final long BACK_WORKER_ID_BEGIN = 16L;
    private static final long SEQUENCE_MAX = 65535L;
    private static final long BACK_TIME_MAX = 1L;
    private static long lastTimestamp = 0L;
    private static long sequence = 0L;
    private static long lastTimestampBak = 0L;
    private static long sequenceBak = 0L;

    public KindId() {
    }

    public static long nextId() {
        return nextId(SystemClock.now() / 1000L);
    }

    private static synchronized long nextId(long timestamp) {
        if (timestamp < lastTimestamp) {
            log.warn("时钟回拨, 启用备份机器ID: now: [{}] last: [{}]", timestamp, lastTimestamp);
            return nextIdBackup(timestamp);
        } else {
            if (timestamp != lastTimestamp) {
                lastTimestamp = timestamp;
                sequence = 0L;
            }

            if (0L == (++sequence & 65535L)) {
                --sequence;
                return nextIdBackup(Math.max(timestamp, lastTimestampBak));
            } else {
                return timestamp - 1577808000L << 21 | WORKER_ID << 16 | sequence;
            }
        }
    }

    private static long nextIdBackup(long timestamp) {
        if (timestamp < lastTimestampBak) {
            if (lastTimestampBak - SystemClock.now() / 1000L > 1L) {
                throw new RuntimeException(String.format("时钟回拨: now: [%d] last: [%d]", timestamp, lastTimestampBak));
            }

            timestamp = lastTimestampBak;
        }

        if (timestamp != lastTimestampBak) {
            lastTimestampBak = timestamp;
            sequenceBak = 0L;
        }

        return 0L == (++sequenceBak & 65535L) ? nextIdBackup(timestamp + 1L) : timestamp - 1577808000L << 21 | (WORKER_ID ^ 16L) << 16 | sequenceBak;
    }

    public static void main(String[] args) {
        Map<Long, Integer> map = new ConcurrentHashMap();
        TimeInterval timeInterval = new TimeInterval();
        timeInterval.restart();

        for (int i = 0; i < 100000; ++i) {
            long id = nextId();
            map.put(id, String.valueOf(id).length());
        }

        PrintStream var10000 = System.out;
        int var10001 = map.size();
        var10000.println("Map after writing: " + var10001 + "  time Cost:" + timeInterval.intervalPretty());
    }

    static {
        long workerId = IdUtil.getDataCenterId(15L);
        if (workerId >= 0L && workerId <= 15L) {
            WORKER_ID = workerId;
        } else {
            throw new IllegalArgumentException(String.format("worker-id [%d] 越界, 有效范围: 0 ~ %d ", workerId, 15L));
        }
    }
}
