package org.violet.common.core.intefaces;


import org.violet.common.core.enums.ParamType;


public interface IEmbedParam {
    /**
     * 参数名
     *
     * @return
     */
    String title();

    /**
     * 返回参数的类型
     *
     * @return
     */
    ParamType type();

    /**
     * 默认值
     *
     * @return
     */
    String defValue();

    /**
     * 是否允许匿名访问
     *
     * @return
     */
    boolean anonAccess();

    /**
     * 参数的可选项
     *
     * @return
     */
    String options();

    /**
     * 描述信息
     *
     * @return
     */
    String description();
}
