package org.violet.common.core.enums;


import org.violet.common.core.annotation.EmbedDict;
import org.violet.common.core.intefaces.IEmbedDic;

@EmbedDict("操作类型")
public enum OptType implements IEmbedDic {
    /**
     * 查询
     */
    SELECT("查询"),
    /**
     * 新增
     */
    SAVE("保存"),
    /**
     * 更新
     */
    UPDATE("更新"),
    /**
     * 删除
     */
    DELETE("删除"),
    /**
     * 登录
     */
    LOGIN("登录"),
    /**
     * 退出登录
     */
    LOGOUT("退出登录"),
    /**
     * 授权
     */
    GRANT("授权"),
    /**
     * 导出
     */
    EXPORT("导出"),
    /**
     * 导入
     */
    IMPORT("导入"),
    /**
     * 预览
     */
    PREVIEW("预览"),
    /**
     * 清除
     */
    CLEAN("清除"),
    /**
     * 测试
     */
    TEST("测试"),
    /**
     * 发布
     */
    PUBLISH("发布"),
    /**
     * 越权访问
     */
    UN_AUTH_ACCESS("越权访问"),
    /**
     * 下载文件
     */
    DOWNLOAD("下载文件"),
    /**
     * 重置密码
     */
    RESET_PASSWORD("重置密码"),

    /**
     *
     */
    SYNC("同步"),
    /**
     * 其他
     */
    OTHER("其他");

    private String text;

    OptType(String text) {
        this.text = text;
    }

    @Override
    public String text() {
        return this.text;
    }

}
