package org.violet.common.core.enums;

import lombok.Getter;

@Getter
public enum HideColumns {
    DELETED("Deleted", "deleted"),
    
    CREATE_BY("CreateBy", "createby"),
    
    MODIFY_BY("ModifyBy", "modifyby"),
    
    CREATE_TIME("CreateTime", "createtime"),
    
    MODIFY_TIME("ModifyTime", "modifytime");
    
    private final String columnCode;
    
    private final String columnName;
    
    HideColumns(String columnCode, String columnName) {
        this.columnCode = columnCode;
        this.columnName = columnName;
    }
    
    public static boolean isHideColumn(String col) {
        return (DELETED.columnCode.equals(col) || CREATE_BY.columnCode.equals(col) || MODIFY_BY.columnCode.equals(col) || CREATE_TIME.columnCode.equals(col) || MODIFY_TIME.columnCode.equals(col));
    }
    
    public static boolean isHideColumnUsName(String columnName) {
        return (DELETED.columnName.equals(columnName) || CREATE_BY.columnName.equals(columnName) || MODIFY_BY.columnName.equals(columnName) || CREATE_TIME.columnName.equals(columnName) || MODIFY_TIME.columnName.equals(columnName));
    }
}