package org.violet.common.core.entity;


import jakarta.validation.constraints.NotBlank;
import lombok.Getter;
import lombok.Setter;
import org.violet.common.core.constants.YesNo;



@Setter
@Getter
public class LoginForm {

    @NotBlank(message = "登录用户名不能为空")
    private String loginName;

    @NotBlank(message = "登录密码不能为空")
    private String loginPassword;

    private boolean rememberMe;

    /**
     * 是否是移动端登录，默认否
     */
    private int isMobile = YesNo.N;

}
