package org.violet.common.core.embed.dict;


import org.violet.common.core.annotation.EmbedDict;
import org.violet.common.core.intefaces.IEmbedDic;


@EmbedDict("权限范围类型")
public enum PurviewType implements IEmbedDic {

    /**
     * 组织机构范围
     */
    ORG("组织机构"),
    /**
     * 部门范围
     */
    DEPT("部门"),
    /**
     * 个人范围
     */
    PERSONAL("用户"),
    /**
     * 角色范围
     */
    ROLE("角色");
    private String text;

    PurviewType(String text) {
        this.text = text;
    }
    public String text() {
        return this.text;
    }
}
