package org.violet.common.core.embed.dict;

import org.violet.common.core.annotation.EmbedDict;
import org.violet.common.core.intefaces.IEmbedDic;

@EmbedDict("首页页面类型")
public enum HomePageType implements IEmbedDic {
    SYS_HOME_PAGE("系统首页"),
    TOPIC_HOME_PAGE("栏目首页"),
    OTHER("其他");
    private String text;

    HomePageType(String text) {
        this.text = text;
    }

    @Override
    public String text() {
        return this.text;
    }
}