package org.violet.common.core.embed.dict;


import org.violet.common.core.annotation.EmbedDict;
import org.violet.common.core.intefaces.IEmbedDic;


@EmbedDict("公共数据权限")
public enum CommonDataAuth implements IEmbedDic {
    ALL_DATA("所有数据"),
    CURRENT_ORG_DATA("本单位数据"),
    CURRENT_DEPT_DATA("本部门数据"),
    CURRENT_EMP_DATA("个人数据"),
    CUSTOM_DATA("自定义");
    private String text;

    CommonDataAuth(String text) {
        this.text = text;
    }

    @Override
    public String text() {
        return this.text;
    }
}
