package org.violet.common.core.convert;

import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.lang.Nullable;
import org.springframework.util.StringValueResolver;

/**
 * 类型 转换 服务，添加了 IEnum 转换
 *
 */
public class VioletConversionService extends ApplicationConversionService {
	@Nullable
	private static volatile VioletConversionService SHARED_INSTANCE;

	public VioletConversionService() {
		this(null);
	}

	public VioletConversionService(@Nullable StringValueResolver embeddedValueResolver) {
		super(embeddedValueResolver);
		super.addConverter(new EnumToStringConverter());
		super.addConverter(new StringToEnumConverter());
	}

	public static GenericConversionService getInstance() {
		VioletConversionService sharedInstance = VioletConversionService.SHARED_INSTANCE;
		if (sharedInstance == null) {
			synchronized (VioletConversionService.class) {
				sharedInstance = VioletConversionService.SHARED_INSTANCE;
				if (sharedInstance == null) {
					sharedInstance = new VioletConversionService();
					VioletConversionService.SHARED_INSTANCE = sharedInstance;
				}
			}
		}
		return sharedInstance;
	}

}
