/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.core.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import java.util.ArrayList;
import java.util.List;
import org.violet.common.core.intefaces.ITreeNode;

public class TreeUtil {
    public static <T extends ITreeNode> List<T> buildTree(List<? extends ITreeNode> nodeList) {
        return TreeUtil.buildTree(nodeList, false);
    }

    public static <T extends ITreeNode> List<T> buildTree(List<? extends ITreeNode> nodeList, boolean cascade) {
        ArrayList<ITreeNode> tree = new ArrayList<ITreeNode>();
        if (CollUtil.isNotEmpty(nodeList)) {
            for (ITreeNode iTreeNode : nodeList) {
                ITreeNode pnode = (ITreeNode)CollUtil.findOne(nodeList, n -> ObjectUtil.equals((Object)n.id(), (Object)node2.pid()));
                if (pnode != null || iTreeNode.pid() != null && !iTreeNode.pid().toString().equals("0") && cascade) continue;
                tree.add(iTreeNode);
            }
        }
        ArrayList todoList = CollUtil.newArrayList(tree);
        while (!todoList.isEmpty()) {
            ITreeNode iTreeNode = (ITreeNode)todoList.get(0);
            todoList.remove(0);
            nodeList.forEach(node -> {
                if (ObjectUtil.equals((Object)todoNode.id(), (Object)node.pid())) {
                    todoNode.addChild(node);
                    todoList.add(node);
                }
            });
        }
        return tree;
    }

    public static <T extends ITreeNode> T findOneById(List<? extends ITreeNode> nodeList, Object id) {
        ITreeNode oneNode = null;
        if (CollUtil.isEmpty(nodeList)) {
            return (T)oneNode;
        }
        for (ITreeNode iTreeNode : nodeList) {
            if (iTreeNode.id().equals(id)) {
                oneNode = iTreeNode;
            } else if (CollUtil.isNotEmpty(iTreeNode.getChildren())) {
                oneNode = TreeUtil.findOneById(iTreeNode.getChildren(), id);
            }
            if (oneNode == null) continue;
            return (T)oneNode;
        }
        return (T)oneNode;
    }

    public static <T> List<T> getChildIds(List<? extends ITreeNode> nodeList, T id, boolean includeSelf) {
        ArrayList<T> childIds = new ArrayList<T>();
        T node = TreeUtil.findOneById(nodeList, id);
        if (node != null) {
            if (includeSelf) {
                childIds.add(id);
            }
            TreeUtil.addChildIds(node.getChildren(), childIds);
        }
        return childIds;
    }

    public static void addChildIds(List<ITreeNode> nodeList, List ids) {
        for (ITreeNode node : nodeList) {
            ids.add(node.id());
            if (!CollUtil.isNotEmpty(node.getChildren())) continue;
            TreeUtil.addChildIds(node.getChildren(), ids);
        }
    }

    public static <T extends ITreeNode> List<T> findByPath(List<T> nodeList, Object targetId) {
        ArrayList path = new ArrayList();
        if (TreeUtil.findPath(path, nodeList, targetId)) {
            return path;
        }
        return null;
    }

    private static <T extends ITreeNode> boolean findPath(List<T> pathList, List<T> nodeList, Object targetId) {
        if (CollUtil.isEmpty(nodeList)) {
            return false;
        }
        for (ITreeNode node : nodeList) {
            if (targetId.equals(node.id())) {
                pathList.add(node);
                return true;
            }
            if (TreeUtil.findPath(pathList, node.getChildren(), targetId)) {
                pathList.add(node);
                return true;
            }
            if (!CollUtil.isNotEmpty(pathList)) continue;
            pathList.remove(pathList.size() - 1);
        }
        return false;
    }
}

