/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.core.util;

import cn.hutool.core.util.ObjectUtil;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaceholderResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlaceholderResolver.class);
    private static final String STR_REGEX = "\\$\\{(.+?)\\}";

    public static String parse(String template, Map<String, String> data) {
        if (ObjectUtil.isEmpty((Object)template)) {
            return "";
        }
        if (ObjectUtil.isEmpty(data)) {
            return template;
        }
        try {
            StringBuffer appendReplaceSb = new StringBuffer();
            Pattern pattern = Pattern.compile(STR_REGEX);
            Matcher matcher = pattern.matcher(template);
            while (matcher.find()) {
                String key = matcher.group(1).trim();
                if (!data.containsKey(key)) continue;
                String value = data.get(key);
                matcher.appendReplacement(appendReplaceSb, value);
            }
            matcher.appendTail(appendReplaceSb);
            return appendReplaceSb.toString();
        }
        catch (Exception e) {
            log.error("\u6a21\u677f:{}\u89e3\u6790\u9519\u8bef,\u5f02\u5e38\u4fe1\u606f:{}", (Object)template, (Object)e.getMessage());
            return template;
        }
    }

    public static String parse(String template, String varname, String value) {
        if (ObjectUtil.isEmpty((Object)template)) {
            return "";
        }
        if (ObjectUtil.isEmpty((Object)varname)) {
            return template;
        }
        try {
            StringBuffer appendReplaceSb = new StringBuffer();
            Pattern pattern = Pattern.compile(STR_REGEX);
            Matcher matcher = pattern.matcher(template);
            while (matcher.find()) {
                String key = matcher.group(1).trim();
                if (!varname.equals(key)) continue;
                matcher.appendReplacement(appendReplaceSb, value);
                break;
            }
            matcher.appendTail(appendReplaceSb);
            return appendReplaceSb.toString();
        }
        catch (Exception e) {
            log.error("\u6a21\u677f:{}\u89e3\u6790\u9519\u8bef,\u5f02\u5e38\u4fe1\u606f:{}", (Object)template, (Object)e.getMessage());
            return template;
        }
    }
}

