/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.core.util;

import java.nio.charset.Charset;
import org.springframework.lang.Nullable;
import org.violet.common.core.util.Charsets;
import org.violet.common.core.util.StringUtil;

public class HexUtil {
    public static final Charset DEFAULT_CHARSET = Charsets.UTF_8;
    private static final byte[] DIGITS_LOWER = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final byte[] DIGITS_UPPER = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public static byte[] encode(byte[] data) {
        return HexUtil.encode(data, true);
    }

    public static byte[] encode(byte[] data, boolean toLowerCase) {
        return HexUtil.encode(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    private static byte[] encode(byte[] data, byte[] digits) {
        int len = data.length;
        byte[] out = new byte[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            out[j++] = digits[(0xF0 & data[i]) >>> 4];
            out[j++] = digits[0xF & data[i]];
        }
        return out;
    }

    public static String encodeToString(byte[] data, boolean toLowerCase) {
        return new String(HexUtil.encode(data, toLowerCase), DEFAULT_CHARSET);
    }

    public static String encodeToString(byte[] data) {
        return new String(HexUtil.encode(data), DEFAULT_CHARSET);
    }

    @Nullable
    public static String encodeToString(@Nullable String data) {
        if (StringUtil.isBlank(data)) {
            return null;
        }
        return HexUtil.encodeToString(data.getBytes(DEFAULT_CHARSET));
    }

    @Nullable
    public static byte[] decode(@Nullable String data) {
        if (StringUtil.isBlank(data)) {
            return null;
        }
        return HexUtil.decode(data.getBytes(DEFAULT_CHARSET));
    }

    @Nullable
    public static String decodeToString(@Nullable String data) {
        byte[] decodeBytes = HexUtil.decode(data);
        if (decodeBytes == null) {
            return null;
        }
        return new String(decodeBytes, DEFAULT_CHARSET);
    }

    public static byte[] decode(byte[] data) {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new IllegalArgumentException("hexBinary needs to be even-length: " + len);
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = HexUtil.toDigit(data[j], j) << 4;
            f |= HexUtil.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    private static int toDigit(byte b, int index) {
        int digit = Character.digit(b, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Illegal hexadecimal byte " + b + " at index " + index);
        }
        return digit;
    }
}

