/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.core.util;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.violet.common.core.exception.BizException;
import org.violet.common.core.util.ObjectUtil;

public class CommonServletUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonServletUtil.class);

    public static String getParamFromRequest(String paramName) {
        Cookie[] cookies;
        HttpServletRequest request = CommonServletUtil.getRequest();
        String paramValue = request.getParameter(paramName);
        if (ObjectUtil.isEmpty((Object)paramValue)) {
            paramValue = request.getHeader(paramName);
        }
        if (ObjectUtil.isEmpty((Object)paramValue) && ObjectUtil.isNotEmpty(cookies = request.getCookies())) {
            Cookie[] var4 = cookies;
            int var5 = cookies.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                Cookie cookie = var4[var6];
                String cookieName = cookie.getName();
                if (!cookieName.equals(paramName)) continue;
                return cookie.getValue();
            }
        }
        return paramValue;
    }

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes servletRequestAttributes;
        try {
            servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        }
        catch (Exception var2) {
            log.error(">>> \u975eWeb\u4e0a\u4e0b\u6587\u65e0\u6cd5\u83b7\u53d6Request\uff1a", (Throwable)var2);
            throw new BizException("\u975eWeb\u4e0a\u4e0b\u6587\u65e0\u6cd5\u83b7\u53d6Request", var2);
        }
        if (servletRequestAttributes == null) {
            throw new BizException("\u975eWeb\u4e0a\u4e0b\u6587\u65e0\u6cd5\u83b7\u53d6Request");
        }
        return servletRequestAttributes.getRequest();
    }

    public static HttpServletResponse getResponse() {
        ServletRequestAttributes servletRequestAttributes;
        try {
            servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        }
        catch (Exception var2) {
            log.error(">>> \u975eWeb\u4e0a\u4e0b\u6587\u65e0\u6cd5\u83b7\u53d6Response\uff1a", (Throwable)var2);
            throw new BizException("\u975eWeb\u4e0a\u4e0b\u6587\u65e0\u6cd5\u83b7\u53d6Response", var2);
        }
        if (servletRequestAttributes == null) {
            throw new BizException("\u975eWeb\u4e0a\u4e0b\u6587\u65e0\u6cd5\u83b7\u53d6Response");
        }
        return servletRequestAttributes.getResponse();
    }

    public static boolean isWeb() {
        return RequestContextHolder.getRequestAttributes() != null;
    }
}

